% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lccall-subject.R
\name{get_lc_call_first_letter}
\alias{get_lc_call_first_letter}
\title{Get the first letter of LC Call Number}
\usage{
get_lc_call_first_letter(x)
}
\arguments{
\item{x}{A Library of Congress call number (string)}
}
\value{
Returns first letter or NA if invalid
}
\description{
Takes a string representation of a Library of Congress
call number and returns the first letter if and only if
the LC Call Number is valid
}
\examples{

get_lc_call_first_letter("Q172.5.E77")
# Q
get_lc_call_first_letter("AF172.5.E77")
# NA

# vectorized
get_lc_call_first_letter(c("Q 172.5", "AF172", "PR6023.A93"))
# Q NA P

}
