% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest_sentences.R
\name{unnest_sentences_}
\alias{unnest_sentences}
\alias{unnest_sentences_}
\title{Split a column of text into sentences}
\usage{
unnest_sentences_(tbl, output, input, output_id = "sent_id", drop = TRUE)

unnest_sentences(tbl, output, input, output_id = "sent_id", drop = TRUE)
}
\arguments{
\item{tbl}{dataframe containing column of text to be split into sentences}

\item{output}{name of column to be created to store parsed sentences}

\item{input}{name of input column of text to be parsed into sentences}

\item{output_id}{name of column to be created to store sentence ids}

\item{drop}{whether original input column should get dropped}
}
\value{
A data.frame of parsed sentences and sentence ids
}
\description{
Split a column of text into sentences
}
\examples{
library(dplyr)

df <- dplyr::tibble(doc_id = 1:3, 
                    text = c("Testing the system. Second sentence for you.", 
                             "System testing the tidy documents df.", 
                             "Documents will be parsed and lexranked."))

unnest_sentences(df, sents, text)
unnest_sentences_(df, "sents", "text")

df \%>\% 
  unnest_sentences(sents, text)
}

