% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/str_snake_case.R
\name{str_snake_case}
\alias{str_snake_case}
\title{str_snake_case}
\usage{
str_snake_case(string, whitespace = getOption("lettercase.whitespace",
  "[^\\\\w\\\\s-\\\\.]"))
}
\arguments{
\item{string}{object to turn into a title case}

\item{whitespace}{regular expression pattern to match for white-space


* characters are all lower case
* non- \code{\\w}, \code{\\s} and - are dropped
* \code{\\w} and - are converted to underscore
* no support for acronyms
* multiple adjacent undescores are replaced by single underscore
* Underscores at beginning or end of names are dropped}
}
\description{
Function used to convert character vectors to snake case format.
}
\examples{
str_snake_case( "One Flew Over The Cuckoo's Nest" )
  str_snake_case( "Catch-22" )  # catch_22
  str_snake_case( "Catch.22" )
  str_snake_case( "Catch_22" )
  str_snake_case( "Catch  22" )
  str_snake_case( " Catch 22 " )
}

