\name{PieChart}
\alias{PieChart}
\alias{pc}

\title{Pie Chart}

\description{
Abbreviation: \code{pc}

Plots a pie chart of a categorical variable (\code{x}). The default chart is a doughnut or ring version of a pie chart, that is, a hole in the middle of the pie. Either directly enter the corresponding numerical value (\code{y}) or have the numerical variable be the tabulated counts for the frequency of occurrence for each value of the categorical variable. Also displays the frequency table for the variable with the corresponding chi-square inferential analysis. Real numbers can also be entered directly.
}

\usage{
PieChart(x, y=NULL, data=d, rows=NULL,

         radius=1, hole=0.65, hole_fill=getOption("panel_fill"),

         fill=NULL, 
         color="lightgray",
         trans=getOption("trans_bar_fill"),

         density=NULL, angle=45,
         lty="solid", lwd=1, edges=200,

         clockwise=FALSE, init_angle=ifelse (clockwise, 90, 0), 

         values=getOption("values"),
         values_color=getOption("values_color"), 
	 values_size=getOption("values_size"),
         values_digits=getOption("values_digits"),
         values_position=getOption("values_position"),

         main=NULL, main_cex=1.2, labels_cex=0.9, cex,

         add=NULL, x1=NULL, y1=NULL, x2=NULL, y2=NULL,

         eval_df=NULL, quiet=getOption("quiet"),
         width=6.5, height=6, pdf_file=NULL,
         \dots)

pc(\ldots)
}

\arguments{
  \item{x}{For each level of this categorical variable, x, display the
        frequencies as slices of a pie.}
  \item{y}{Numeric variable that sets the area of each slice of the pie.
        If not specified,
        then its value is the frequency of each category of \code{x},
        automatically tabulated.}
  \item{data}{Optional data frame that contains the variable(s) of interest,
        default is \code{d}.}
  \item{rows}{A logical expression that specifies a subset of rows of the data frame
       to analyze.}\cr

  \item{radius}{The pie is drawn in a box with sides that range from -1 to 1,
        so the maximum value of the radius without truncating the pie is 1.}
  \item{hole}{The proportion of the radius that defines the inner hole
        for what is called a doughnut or hole plot. To show the full pie,
        set to \code{FALSE} or the value of \code{0}.}
  \item{hole_fill}{Fill color of the hole, which by default is the same color as
       \code{panel_fill} as set by the color theme or individually with
       the \code{\link{style}} function.} \cr


  \item{fill}{Specified color of each slice. Default is the discrete 
        scale with, with fixed
        chroma (50) and luminance (75) for unbiased comparison 
        across colors, for all color themes except 
        \code{"gray"} and \code{"white"}, with default gray scale.
        Can explicitly choose \code{"grays"}
        or \code{"hues"} , or pre-specified R color schemes 
        \code{"rainbow"}, \code{"terrain"}, and \code{"heat"}. 
        Or, set to the name of \code{y} to map the values of bar fill,
        specified as \code{(count)} if tabulated from the data. Can also
        provide pre-defined color ranges \code{"blues"}, \code{"reds"}
        and \code{"greens"}, as well as
        custom colors, such as generated by \code{\link{getColors}}.}
  \item{color}{Border color of sides and the pie, can be a vector
        to customize the color for each slice. Default is
        \code{bar_color} from the lessR \code{\link{style}} function.}
  \item{trans}{Transparency factor of the area of each slice.
        Default is
        \code{trans_bar_fill} from the lessR \code{\link{style}} function.}\cr
  

  \item{density}{Density of shading lines, in lines per inch. Default value is
       \code{NULL}, that is, no shading lines.}
  \item{angle}{Angle of shading lines in degrees.}

  \item{lty}{Type of line that borders each slice, such as "solid", the default.
        Can be a vector. Acceptable values are \code{"blank"}, \code{"solid"},
        \code{"dashed"}, \code{"dotted"}, \code{"dotdash"}, and \code{"longdash"}.}
  \item{lwd}{Width of line that borders each slice.}
  \item{edges}{Approximation of a circle with a polygon drawn with the 
       number of specified edges.}\cr



  \item{clockwise}{Default value of \code{FALSE} specifies to draw the
        slices counter-clockwise, otherwise clockwise.}
  \item{init_angle}{Starting angle (in degrees) for the slices. For counter-clockwise
       the default value is 0 (3 o'clock), otherwise 90 (12 o'clock).}\cr


  \item{values}{If not the default value of \code{"off"}, adds the
        numerical results to the plot according to \code{"\%"}, 
        \code{"prop"} or \code{"input"}, that is, percentages,
         proportions, or the value from which the slices are plotted,
         such as tabulated counts if \code{y} is not specified,
         or the value of \code{y} if the plotted values are provided. If
         any other \code{values} parameter is specified, default is set
         to \code{"\%"}.}
  \item{values_color}{Color of the plotted text. Could be a vector to specify
        a unique color for each value. If fewer colors are specified than
        the number of categories, the colors are recycled.}
  \item{values_size}{Character expansion factor, the size, of the plotted text, 
        for which the default value is 0.95.}
  \item{values_digits}{Number of decimal digits for which to display the values_
        Default is 0, round to the nearest integer, for \code{"\%"}
        and 2 for \code{"prop"}.}
  \item{values_position}{Position of the plotted text. Default is inside the pie,
        or, if \code{"label"}, as part of the label for each value
        outside of the pie.}\cr


  \item{main}{Title of graph. Set the color with \code{main_color} with
       the \code{\link{style}} function.}
  \item{main_cex}{Character expansion factor of title relative to 1.}
  \item{labels_cex}{Character expansion factor of labels relative to 1. No
       labels if set to 0.}
  \item{cex}{General character expansion factor for default values of 
        main_cex, labels_cex, and values_size. Useful for adjustment of text
        for larger or smaller images.}\cr


  \item{add}{\bold{Draw one or more objects}, text or a geometric figures,
       on the plot.
       Possible values are any text to be written, the first argument, which is
       \code{"text"}, or, to indicate a figure,
       \code{"rect"} (rectangle), \code{"line"}, \code{"arrow"},
       \code{"v.line"} (vertical line), and \code{"h.line"} (horizontal line).
       The value \code{"means"} is short-hand for vertical and horizontal lines
       at the respective means. Does not apply to Trellis graphics.
       Customize with parameters such as \code{fill} and \code{color}
       from the \code{\link{style}} function.}
  \item{x1}{First x coordinate to be considered for each object.
           All coordinates vary from -1 to 1.}
  \item{y1}{First y coordinate to be considered for each object.}
  \item{x2}{Second x coordinate to be considered for each object.
        Only used for \code{"rect"}, \code{"line"} and \code{arrow}.}
  \item{y2}{Second y coordinate to be considered for each object.
        Only used for \code{"rect"}, \code{"line"} and \code{arrow}.}\cr

  \item{eval_df}{Determines if to check for existing data frame and
        specified variables. By default is \code{TRUE} 
        unless the \code{shiny} package is loaded then set to \code{FALSE} so
        that Shiny will run. Needs to be set to \code{FALSE} if using
        the pipe \code{\%\>\%} notation.}
  \item{quiet}{If set to \code{TRUE}, no text output. Can change system default
       with \code{\link{style}} function.}
  \item{width}{Width of the plot window in inches, defaults to 4.5.}
  \item{height}{Height of the plot window in inches, defaults to 4.5.}
  \item{pdf_file}{Name of the pdf file to if graphics to be redirected to a
        pdf file.}\cr


  \item{...}{Other parameter values for graphics as defined processed 
      by \code{\link{pie}} and \code{\link{par}} for general graphics,
      which includes \code{radius} of the pie, and \code{color_main} for
      the title of the graph.}
}


\details{
OVERVIEW\cr
Plot a pie chart with default colors, presumably with a relatively small number of values for each variable.  By default, colors are selected for the slices, background and grid lines, all of which can be customized. The basic computations of the chart are provided with the standard R functions \code{\link{pie}} and \code{\link{chisq.test}} and the \code{lessR} function  \code{\link{chisq.test}}. A minor modification of the original \code{\link{pie}} code provides for the hole in the middle of the pie, the default doughnut or ring chart.

DATA\cr
The data may either be a vector from the global environment, the user's workspace, as illustrated in the examples below, or one or more variable's in a data frame, or a complete data frame. The default input data frame is \code{d}. Can specify the source data frame name with the \code{data} option.  If multiple variables are specified, only the numerical variables in the list of variables are analyzed. The variables in the data frame are referenced directly by their names, that is, no need to invoke the standard \code{R} mechanisms of the \code{d$name} notation, the \code{\link{with}} function or the  \code{\link{attach}} function. If the name of the vector in the global environment and of a variable in the input data frame are the same, the vector is analyzed.
       
The \code{rows} parameter subsets rows (cases) of the input data frame according to a logical expression. Use the standard R operators for logical statements as described in \code{\link{Logic}} such as \code{&} for and, \code{|} for or and \code{!} for not, and use the standard R relational operators as described in \code{\link{Comparison}} such as \code{==} for logical equality \code{!=} for not equals, and \code{>} for greater than. See the Examples.

COLORS\cr
Set the default color of the bars by the current color theme according to \code{bar_fill_discrete} argument of the function \code{\link{style}}, which includes the default color theme \code{"colors"} that defines a qualitative HCL color scale, or set the bar color with the \code{fill} parameter. These parameters reference a specified vector of color specifications, such as generated by the lessR \code{\link{getColors}} function.

Set \code{fill} to a single color or a color palette, of which there are many possibilities. Define a qualitative color palette with \code{"hues"} that provides HCL colors of the same chroma (saturation) and luminance (brightness). Also available are the pre-specified R color palettes \code{"rainbow"}, \code{"terrain"}, and \code{"heat"}. Pre-defined sequential and divergent color ranges are available as implicit calls to \code{\link{getColors}}. The full list of pre-defined color ranges (defined in 30 degree increments around the HCL color wheel): \code{"reds"}, \code{"rusts"}, \code{"browns"}, 
\code{"olives"}, \code{"greens"}, \code{"emeralds"}, \code{"turquoises"}, \code{"aquas"}, \code{"blues"}, \code{"purples"},\code{"violets"}, \code{"magentas"}, and \code{"grays"}.

Defines a \emph{sequential color scale} with single value of \code{fill} for a pre-defined palette such as \code{"blues"}. Or, \emph{manually specify colors}. For example, for a two-level \code{by} variable, could set \code{fill} to \code{c("coral3","seagreen3")}, where the specified colors are \emph{not} pre-defined color ranges.

For the pre-defined color scales can obtain more control over the obtained color palettes with an explicit call to \code{\link{getColors}} for the argument to \code{fill}. Here the value of chroma (\code{c}) and luminance (\code{l}) can be explicitly manipulated in conjunction with the specification of a pre-defined color range. Or, create a custom color range for any value of hue (\code{h}). See  \code{\link{getColors}} for more information. 

To change the background color, set the \code{"panel_fill"} argument of the \code{\link{style}} function. The hole of the pie defaults to that color, which, of course, can also be specified to a different color_ 

ANNOTATIONS\cr
Use the \code{add} and related parameters to annotate the plot with text and/or geometric figures_ Each object is placed according from one to four corresponding coordinates, the required coordinates to plot that object, as shown in the following table. The values of the coordinates vary from -1 to 1.\cr

\tabular{lll}{
Value \tab Object \tab Required Coordinates\cr
----------- \tab ------------------- \tab ----------------\cr
text \tab text \tab x1, x2\cr
\code{"rect"} \tab rectangle \tab x1, y1, x2, y2\cr
\code{"line"} \tab line segment \tab x1, y1, x2, y2\cr
\code{"arrow"} \tab arrow \tab x1, y1, x2, y2\cr
----------- \tab ------------------- \tab ----------------\cr
}

The value of \code{add} specifies the object. For a single object, enter a single value. Then specify the value of the needed corresponding coordinates, as specified in the above table. For multiple placements of that object, specify vectors of corresponding coordinates. To annotate multiple objects, specify multiple values for \code{add} as a vector. Then list the corresponding coordinates, for up to each of four coordinates, in the order of the objects listed in \code{add}. See the examples for illustrations.

Can also specify vectors of different properties, such as \code{add_color}. That is, different objects can be different colors, different transparency levels, etc.

STATISTICS\cr
In addition to the pie chart, descriptive and inferential statistics are presented.  First, for integer variables such as counts, the frequency table with proportions is displayed. Second, the corresponding chi-square test is also displayed. For real valued variables read from a data frame, the summary statistics such as the mean are reported.

PDF OUTPUT\cr
Because \code{lessR} functions generate their own graphics calls, the standard graphic output functions such as \code{\link{pdf}} do not work with the \code{lessR} graphics functions.  Instead, to obtain pdf output, use the \code{pdf_file} option, perhaps with the optional \code{width} and \code{height} options. These files are written to the default working directory, which can be explicitly specified with the R \code{\link{setwd}} function.

ONLY VARIABLES ARE REFERENCED\cr
The referenced variable in a \code{lessR} function can only be a variable name. This referenced variable must exist in either the referenced data frame, \code{d} by default, or in the user's workspace, more formally called the global environment. That is, expressions cannot be directly evaluated. For example:

\code{    > PieChart(rnorm(10))   # does NOT work}

Instead, do the following:
\preformatted{    > Y <- rnorm(10)   # create vector Y in user workspace
    > PieChart(Y)     # directly reference Y}
}


\author{David W. Gerbing (Portland State University; \email{gerbing@pdx.edu})}

\seealso{
\code{\link{pie}}, \code{\link{chisq.test}}.
}


\examples{
# get the data from a file included with lessR
d <- rd("Employee")

# --------------------------------------------------------
# pie (doughnut) chart from the data for a single variable
# --------------------------------------------------------

# basic pie chart, actually a doughnut or ring chart
# with default hcl colors (except for themes "gray" and "white")
PieChart(Dept)
# short name
#pc(Dept)

# standard pie chart with no hole
pc(Dept, hole=0)

# specify a unique slice color for each of the two slices
# turn off borders
PieChart(Gender, fill=c("pink","lightblue"), lty="blank")

# just males with a salary larger than 75000 USD
PieChart(Dept, rows=(Gender=="M" & Salary > 75000))

# use getColors function to create the pie slice colors
# here as a separate function call
# need to set the correct number of colors to span the full range
mycolors <- getColors("aliceblue", end_pal="steelblue", n=5)
PieChart(Dept, fill=mycolors)

# specify the colors from a predefined color palette
# see ?getColors
PieChart(Dept, fill="blues")

# viridis color palette
PieChart(Dept, fill="viridis")

# display the percentage inside each slice of the pie
# provide a unique color for each displayed value
PieChart(Dept, values="\%",
         values_color=c("yellow", "pink", "blue", "purple", "brown"))

# display the counts inside each slice of the pie
# reduce size of displayed counts to 0.75
PieChart(Dept, values="input", values_size=0.75,
         values_color=getOption("window_fill"))

# add transparency and custom color for the displayed values
PieChart(Dept, trans=.6, values="\%", values_color=rgb(.3,.3,.3))

# map counts of each level to the fill color of the corresponding slice
PieChart(JobSat, fill=(count))


# ------------------------------
# pie chart directly from counts
# ------------------------------

# from vector
# pie chart of one variable with three levels
# enter counts as a vector with the combine function, c
# must supply the level names and variable name
# use abbreviation pc for PieChart
City <- c(206, 94, 382)
names(City) <- c("LA","Chicago","NY")
pc(City, main="Employees in Each City")

# counts from data frame
x <- c("ACCT", "ADMN", "FINC", "MKTG", "SALE")
y <- c(5, 6, 4, 6, 15)
d <- data.frame(x,y)
names(d) <- c("Dept", "Count")
PieChart(Dept, Count)

# real numbers from data frame 
Dept <- c("ACCT", "ADMN", "FINC", "MKTG", "SALE")
Salary <- c(86208.42, 29808.29, 42305.52, 75855.81, 65175.51)
d <- data.frame(x,y)
pc(Dept, Salary)
rm(Dept)
rm(Salary)

# -----------
# annotations
# -----------

d <- rd("Employee")

# Place a message in the center of the pie
# Use \n to indicate a new line
PieChart(Dept, add="Employees by\nDepartment", x1=0, y1=0)

# Use style to change some parameter values
style(add_trans=.8, add_fill="gold", add_color="gold4", add_lwd=0.5)
# Add a rectangle around the message centered at <0,0>
PieChart(Dept, add=c("rect", "Employees by\nDepartment"),
                     x1=c(-.4,0), y1=c(-.2, 0), x2=.4, y2=.2)

}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ pie chart }
\keyword{ color }

