% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-pointline.r
\name{geom_pointpath}
\alias{geom_pointpath}
\alias{geom_pointline}
\alias{geom_pointrangeline}
\title{Connected points}
\usage{
geom_pointpath(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  distance = unit(3, "pt"),
  shorten = 0.5,
  threshold = 0.1,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  linesize = 0.5,
  linecolour = waiver(),
  linecolor = waiver(),
  arrow = NULL,
  ...
)

geom_pointline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  distance = unit(3, "pt"),
  shorten = 0.5,
  threshold = 0.1,
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  linesize = 0.5,
  linecolour = waiver(),
  linecolor = waiver(),
  arrow = NULL,
  ...
)

geom_pointrangeline(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  distance = unit(3, "pt"),
  lineend = "butt",
  linejoin = "round",
  linemitre = 1,
  linesize = 0.5,
  linecolour = waiver(),
  linecolor = waiver(),
  arrow = NULL,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}}
or \code{\link[ggplot2]{aes_}}.}

\item{data}{The data to be displayed in this layer.}

\item{stat}{The statistical transformation to use on the data for this layer, 
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a 
call to a position adjustment function
(e.g. \code{\link[ggplot2]{position_jitter}}).
Both lines and points gets the same adjustment 
(\emph{this} is where the function excels over \code{geom_point() + geom_line()}).}

\item{na.rm}{If \code{FALSE} (default), missing values are removed with a warning.
If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{Logical. Should this layer be included in the legends?
\code{NA} (default), includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetic, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the 
default plot specification.}

\item{distance}{Gap size between point and end of lines;
use \code{\link[grid]{unit}}. Is converted to 'pt' if given as simple numeric.
When \code{NULL} or \code{NA}, gapping and \code{shorten}/\code{treshold}
is disabled. To keep the latter, set to 0.}

\item{shorten, threshold}{When points are closer than \code{threshold},
shorten the line by the proportion in \code{shorten} instead of adding
a gap by \code{distance}.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{linemitre}{Line mitre limit (number greater than 1).}

\item{linesize}{Width of of line.}

\item{linecolour, linecolor}{When not \code{waiver()}, the line is drawn with 
this colour instead of that set by aesthetic \code{colour}.}

\item{arrow}{Arrow specification, as created by \code{\link[grid]{arrow}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}.}
}
\description{
\code{geom_pointpath} combines \code{\link[ggplot2]{geom_point}} and 
\code{\link[ggplot2]{geom_path}}, such that a) when jittering is used,
both lines and points stay connected, and b) provides a visual effect
by adding a small gap between the point and the end of line.
\code{geom_pointline} combines \code{\link[ggplot2]{geom_point}} and
\code{\link[ggplot2]{geom_path}}.
}
\details{
\code{geom_pointpath} connects the observations in the same order in which
they appear in the data.
\code{geom_pointline} connects them in order of the variable on the x-axis.

Both \code{geom_pointpath} and \code{geom_pointline} will only 
connect observations within the same group! However,
if \code{linecolour} is \emph{not} \code{waiver()}, connections
will be made between groups, but possible in an incorrect order.
}
\section{Aesthetics}{

\code{geom_pointline} and \code{geom_pointpath} understands the following 
aesthetics (required aesthetics are in bold):
\itemize{
  \item \strong{x}
  \item \strong{y}
  \item alpha
  \item colour -- sets colour of point. Only affects line if \code{linecolour=waiver()}. 
  \item stroke
  \item shape
  \item stroke
  \item group
  \item linetype
  \item size -- only affects point size. Width of line is set with 
        \code{linesize} and cannot be linked to an aesthetic.
}
}

\examples{
# geom_point examples
library(ggplot2)

p <- ggplot(mtcars, aes(wt, mpg))
p + geom_point() + geom_line()
p + geom_pointline()

p + geom_pointline(linecolour='brown')

p + geom_pointpath()

# Add aesthetic mappings
p + geom_pointline(aes(colour = factor(cyl)))
# Using linecolour preserved groups.
p + geom_pointline(aes(colour = factor(cyl)), linecolour='brown') 

## If you want to combine the pretty lines of pointline that do *not* respect
## grouping (or order), combine several layers with geom_point on top:
p + geom_pointline() + geom_point(aes(colour=factor(cyl)))

# Change scales
p + geom_pointline(aes(colour = cyl)) + scale_colour_gradient(low = "blue")
p + geom_pointline(aes(colour = cyl), linecolour='black') + scale_colour_gradient(low = "blue")
p + geom_pointline(aes(shape = factor(cyl))) + scale_shape(solid = FALSE)

# For shapes that have a border (like 21), you can colour the inside and
# outside separately. Use the stroke aesthetic to modify the width of the
# border
ggplot(mtcars, aes(wt, mpg)) +
  geom_pointline(shape = 21, colour = "black", fill = "white", 
                 size = 5, stroke = 5, distance = unit(10, 'pt'))

## Another example
df <- data.frame(x=rep(c('orange','apple','pear'), each=3), 
                 b=rep(c('red','green','purple'), times=3), y=runif(9))
ggplot(df, aes(x=x, y=y, colour=b, group=b)) + 
  geom_pointline(linesize=1, size=2, distance=6) + theme_bw()

# geom_pointline() is suitable for time series
ggplot(economics, aes(date, unemploy)) + geom_pointline()
ggplot(economics_long, aes(date, value01, colour = variable)) +
  geom_pointline()
}
