% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param.R
\name{param_defaults}
\alias{param_defaults}
\alias{param_new}
\title{Default parameters}
\usage{
param_defaults(values)

param_new(values)
}
\arguments{
\item{values}{optional named numeric \code{vector}, values will override any
defaults}
}
\value{
named \code{list}
}
\description{
Returns the default Lemna model parameters as reported by Klein et al. (2021).
}
\details{
\subsection{Model parameters}{
\subsection{Growth model}{
\itemize{
\item Model switch for unlimited growth conditions, \code{k_photo_fixed} (TRUE/FALSE)
\item Maximum photosynthesis rate, \code{k_photo_max} (d-1)
\item Reference loss rate, \code{k_loss} (d-1)
\item Lower biomass abundance threshold, \code{BM_threshold} (g dw m-2)
\item Reservoir for biomass recovery, \code{BM_min} (g dw m-2)
}
}

\subsection{Temperature response of photosynthesis}{
\itemize{
\item Optimum growth temperature, \code{T_opt} (°C)
\item Minimum growth temperature, \code{T_min} (°C)
\item Maximum growth temperature, \code{T_max} (°C)
}
}

\subsection{Temperature response of biomass loss rate}{
\itemize{
\item Temperature coefficient, \code{Q10} (-)
\item Reference temperature for response=1, \code{T_ref} (°C)
}
}

\subsection{Irradiance reponse of photosynthesis}{
\itemize{
\item Slope of irradiance response, \code{alpha} (m2 d kJ-1)
\item Intercept of irradiance response, \code{beta} (-)
}
}

\subsection{Nutrient response of photosynthesis}{
\itemize{
\item Half-saturation constant of Nitrogen, \code{N_50} (mg N L-1)
\item Half-saturation constant of Phosphorus, \code{P_50} (mg P L-1)
}
}

\subsection{Density dependence of photosynthesis}{
\itemize{
\item Carrying capacity, \code{BM_L} (g dw m-2)
}
}

\subsection{Concentration response (Toxicodynamics)}{
\itemize{
\item Internal concentration resulting in 50\% effect, \code{EC50_int} (ug L-1)
\item Maximum inhibition c, \code{E_max} (-)
\item Slope parameter, \code{b} (-)
}
}

\subsection{Internal concentration (Toxicokinetics)}{
\itemize{
\item Permeability, \code{P} (cm d-1)
\item Area per dry-weight ratio, \code{r_A_DW} (cm2 g-1)
\item Fresh weight per dry weight ratio, \code{r_FW_DW} (-)
\item Fresh weight density, \code{r_FW_V} (g cm-3)
\item Dry weight per frond ratio, \code{r_DW_FN} (g dw)
\item Partitioning coefficient plant:water, \code{K_pw} (-)
\item Metabolisation rate, \code{k_met} (d-1)
}
}

}
}
\section{Functions}{
\itemize{
\item \code{param_new}: A parameter set without default values
}}

\examples{
# Returns default model parameters, some parameters are not defined (NA)
param_defaults()

# Overwrite one of the default parameters
param_defaults(list(k_photo_max = 0.42))

# Provide values for substance specific TKTD parameters
param_defaults(list(
  EC50_int = 23, # 50\% effect level (mass per volume)
  b = 1,         # slope parameter (-)
  P = 0.42       # permeability (cm d-1)
))

# Returns a list of required model parameters with all values set to NA
param_new()
}
