% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitive-labels.R
\name{primitive_labels}
\alias{primitive_labels}
\title{Guide primitive: labels}
\usage{
primitive_labels(
  key = NULL,
  angle = waiver(),
  n.dodge = 1,
  check.overlap = FALSE,
  theme = NULL,
  position = waiver()
)
}
\arguments{
\item{key}{A \link[=key_standard]{standard key} specification. See more information
in the linked topic.}

\item{angle}{A specification for the text angle. Compared to setting the \code{angle} argument
in \code{\link[ggplot2:element]{element_text()}}, this argument uses some
heuristics to automatically pick the \code{hjust} and \code{vjust} that you
probably want. Can be one of the following:
\itemize{
\item \code{NULL} to take angles and justification settings directly from the theme.
\item \code{\link[ggplot2:waiver]{waiver()}} to allow reasonable defaults in special
cases.
\item A \verb{<numeric[1]>} between -360 and 360 for the text angle in degrees.
}}

\item{n.dodge}{An positive \verb{<integer[1]>} setting the number of layers text
labels can occupy to avoid overlapping labels.}

\item{check.overlap}{A \verb{<logical[1]>} indicating whether to check for and
omit overlapping text. If \code{TRUE}, first, last and middle labels are
recursively prioritised in that order. If \code{FALSE}, all labels are drawn.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}
}
\value{
A \verb{<PrimitiveLabels>} primitive guide that can be used inside other
guides.
}
\description{
This function constructs a labels \link[=guide-primitives]{guide primitive}.
}
\section{Styling options}{
Below are the \link[ggplot2:theme]{theme} options that determine the styling of
this guide, which may differ depending on whether the guide is used in
an axis or in a legend context.
\subsection{As an axis guide}{
\itemize{
\item \verb{axis.text.\{x/y\}.\{position\}} an \code{\link[ggplot2:element]{<element_text>}}
for the display of the labels.
}
}

\subsection{As a legend guide.}{
\itemize{
\item \code{legend.text} an \code{\link[ggplot2:element]{<element_text>}} for the display
of the labels.
}
}
}

\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
 geom_point()

# Adding as secondary guides
p + guides(
  x.sec = primitive_labels(),
  y.sec = primitive_labels(n.dodge = 2)
)
}
\seealso{
Other primitives: 
\code{\link{primitive_box}()},
\code{\link{primitive_bracket}()},
\code{\link{primitive_fence}()},
\code{\link{primitive_line}()},
\code{\link{primitive_segments}()},
\code{\link{primitive_spacer}()},
\code{\link{primitive_ticks}()},
\code{\link{primitive_title}()}
}
\concept{primitives}
