% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lathyrus}
\alias{lathyrus}
\title{Demographic Dataset of \emph{Lathyrus vernus} Population}
\format{
A data frame with 1119 individuals and 34 variables. Each row
corresponds to a unique individual, and each variable from \code{Volume88}
on refers to the state of the individual in a given year.

\describe{
  \item{SUBPLOT}{A variable refering to patch within the population.}
  \item{GENET}{A numeric variable giving a unique number to each 
  individual.}
  \item{Volume88}{Aboveground volume in cubic mm in 1988.}
  \item{lnVol88}{Natural logarithm of \code{Volume88}.}
  \item{FCODE88}{Equals 1 if flowering and 0 if not flowering in 1988.}
  \item{Flow88}{Number of flowers in 1988.}
  \item{Intactseed88}{Number of intact mature seeds produced in 1988.
  Not always an integer, as in some cases seed number was estimated via 
  linear modeling.}
  \item{Dead1988}{Marked as 1 if known to be dead in 1988.}
  \item{Dormant1988}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1988.}
  \item{Missing1988}{Marked as 1 if not found in 1988.}
  \item{Seedling1988}{Marked as 1, 2, or 3 if observed as a seedling in year
  \emph{t}. Numbers refer to certainty of assignment: 1 = certain that plant
  is a seedling in 1988, 2 = likely that plant is a seedling in 1988,
  3 = probable that plant is a seedling in 1988.}
  \item{Volume89}{Aboveground volume in cubic mm in 1989.}
  \item{lnVol89}{Natural logarithm of \code{Volume89}.}
  \item{FCODE89}{Equals 1 if flowering and 0 if not flowering in 1989.}
  \item{Flow89}{Number of flowers in 1989.}
  \item{Intactseed89}{NZumber of intact mature seeds produced in 1989.
  Not always an integer, as in some cases seed number was estimated via
  linear modeling.}
  \item{Dead1989}{Marked as 1 if known to be dead in 1989.}
  \item{Dormant1989}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1989.}
  \item{Missing1989}{Marked as 1 if not found in 1989.}
  \item{Seedling1989}{Marked as 1, 2, or 3 if observed as a seedling in
  year \emph{t}. Numbers refer to certainty of assignment: 1 = certain 
  that plant is a seedling in 1989, 2 = likely that plant is a seedling 
  in 1989, 3 = probable that plant is a seedling in 1989.}
  \item{Volume90}{Aboveground volume in mm<sup>3</sup> in 1990.}
  \item{lnVol90}{Natural logarithm of \code{Volume90}.}
  \item{FCODE90}{Equals 1 if flowering and 0 if not flowering in 1990.}
  \item{Flow90}{Number of flowers in 1990.}
  \item{Intactseed90}{NZumber of intact mature seeds produced in 1990.
  Not always an integer, as in some cases seed number was estimated via 
  linear modeling.}
  \item{Dead1990}{Marked as 1 if known to be dead in 1990.}
  \item{Dormant1990}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1990.}
  \item{Missing1990}{Marked as 1 if not found in 1990.}
  \item{Seedling1990}{Marked as 1, 2, or 3 if observed as a seedling in
  year \emph{t}. Numbers refer to certainty of assignment: 1 = certain 
  that plant is a seedling in 1990, 2 = likely that plant is a seedling
  in 1990, 3 = probable that plant is a seedling in 1990.}
  \item{Volume91}{Aboveground volume in mm<sup>3</sup> in 1991.}
  \item{lnVol91}{Natural logarithm of \code{Volume91}.}
  \item{FCODE91}{Equals 1 if flowering and 0 if not flowering in 1991.}
  \item{Flow91}{Number of flowers in 1991.}
  \item{Intactseed91}{NZumber of intact mature seeds produced in 1991.
  Not always an integer, as in some cases seed number was estimated via
  linear modeling.}
  \item{Dead1991}{Marked as 1 if known to be dead in 1991.}
  \item{Dormant1991}{Marked as 1 if known to be alive but vegetatively 
  dormant in 1991.}
  \item{Missing1991}{Marked as 1 if not found in 1991.}
  \item{Seedling1991}{Marked as 1, 2, or 3 if observed as a seedling 
  in year \emph{t}. Numbers refer to certainty of assignment: 
  1 = certain that plant is a seedling in 1991, 2 = likely that plant 
  is a seedling in 1991, 3 = probable that plant is a seedling in 
  1991.}
}
}
\source{
Ehrlen, J. 2000. The dynamics of plant populations: does the 
history of individuals matter? \emph{Ecology} 81(6):1675-1684.
}
\usage{
data(lathyrus)
}
\description{
A dataset containing the states and fates of \emph{Lathyrus vernus} (spring
vetch), family Fabaceae, from a population in Sweden monitored annually
from 1988 to 1991 in six study plots.
}
\examples{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr", 
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r", 
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector, 
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector, 
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec, 
  propstatus = propvector)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988, 
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9, 
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988", 
  nonobsacol = "Dormant1988", stageassign = lathframeln, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, NAas0 = TRUE, censor = TRUE)

summary(lathvertln)

}
\keyword{datasets}
