% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixcreation.R
\name{aflefko2}
\alias{aflefko2}
\title{Create Function-based Ahistorical Age x Stage Matrix Projection Model}
\usage{
aflefko2(
  year = 1,
  patch = NA,
  stageframe,
  repmatrix = NA,
  overwrite = NA,
  data = NA,
  modelsuite = NA,
  surv_model = NA,
  obs_model = NA,
  size_model = NA,
  repst_model = NA,
  fec_model = NA,
  jsurv_model = NA,
  jobs_model = NA,
  jsize_model = NA,
  jrepst_model = NA,
  paramnames = NA,
  inda = 0,
  indb = 0,
  indc = 0,
  surv_dev = 0,
  obs_dev = 0,
  size_dev = 0,
  repst_dev = 0,
  fec_dev = 0,
  jsurv_dev = 0,
  jobs_dev = 0,
  jsize_dev = 0,
  jrepst_dev = 0,
  repmod = 1,
  yearcol = "year2",
  patchcol = "patchid",
  year.as.random = FALSE,
  patch.as.random = FALSE,
  final_age = 10,
  continue = TRUE,
  randomseed = NA,
  negfec = FALSE,
  reduce = FALSE
)
}
\arguments{
\item{year}{A variable corresponding to year or observation time, or a set
of such values, given in values associated with the year term used in linear 
model development. Can also equal \code{all}, in which case matrices will
be estimated for all years. Defaults to \code{all}.}

\item{patch}{A variable designating which patches or subpopulations will have
matrices estimated. Should be set to specific patch names, or to \code{all}
if matrices should be estimated for all patches. Defaults to \code{all}.}

\item{stageframe}{A stageframe object that includes information on the size,
observation status, propagule status, immaturity status, and maturity status
of each ahistorical stage. Should also incorporate bin widths if size is
continuous.}

\item{repmatrix}{A matrix composed mostly of 0s, with non-zero values for
each potentially new individual (row) born to each reproductive stage
(column). Entries act as multipliers on fecundity, with 1 equaling full
fecundity.}

\item{overwrite}{A data frame developed with the \code{\link{overwrite}()}
function describing transitions to be overwritten either with given values or 
with other estimated transitions.}

\item{data}{The original historical demographic data frame used to estimate
vital rates (class \code{hfvdata}). The original data frame is required in
order to initialize years and patches properly.}

\item{modelsuite}{An optional \code{lefkoMod} object holding the vital rate
models. If given, then \code{surv_model}, \code{obs_model}, 
\code{size_model}, \code{repst_model}, \code{fec_model}, \code{jsurv_model},
\code{jobs_model}, \code{jsize_model}, \code{jrepst_model}, 
\code{paramnames}, \code{yearcol}, and \code{patchcol} are not required. No
models should include size or reproductive status in time \emph{t}-1.}

\item{surv_model}{A linear model predicting survival probability. This can be
a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. If given, then will overwrite any
survival probability model given in \code{modelsuite}. This model must have
been developed in a modeling exercise testing only the impacts of time
\emph{t}.}

\item{obs_model}{A linear model predicting sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. If given, then
will overwrite any observation probability model given in \code{modelsuite}.
This model must have been developed in a modeling exercise testing only the
impacts of time \emph{t}.}

\item{size_model}{A linear model predicting size. This can be a model of
class \code{glm} or \code{glmer}, both of which require a predicted poisson
variable under a log link, or a model of class \code{lm} or \code{lmer}, in
which a Gaussian response is assumed. If given, then will overwrite any size
model given in \code{modelsuite}. This model must have been developed in a
modeling exercise testing only the impacts of time \emph{t}.}

\item{repst_model}{A linear model predicting reproduction probability. This
can be a model of class \code{glm} or \code{glmer}, and requires a predicted
binomial variable under a logit link. If given, then will overwrite any
reproduction probability model given in \code{modelsuite}. This model must
have been developed in a modeling exercise testing only the impacts of time
\emph{t}.}

\item{fec_model}{A linear model predicting fecundity. This can be a model of
class \code{glm} or \code{glmer}, and requires a predicted poisson variable
under a log link. If given, then will overwrite any fecundity model given in
\code{modelsuite}. This model must have been developed in a modeling exercise
testing only the impacts of time \emph{t}.}

\item{jsurv_model}{A linear model predicting juvenile survival probability.
This can be a model of class \code{glm} or \code{glmer}, and requires a
predicted binomial variable under a logit link. If given, then will overwrite
any juvenile survival probability model given in \code{modelsuite}. This
model must have been developed in a modeling exercise testing only the
impacts of time \emph{t}.}

\item{jobs_model}{A linear model predicting juvenile sprouting or observation
probability. This can be a model of class \code{glm} or \code{glmer}, and
requires a predicted binomial variable under a logit link. If given, then
will overwrite any juvenile observation probability model given in
\code{modelsuite}. This model must have been developed in a modeling exercise
testing only the impacts of time \emph{t}.}

\item{jsize_model}{A linear model predicting juvenile size. This can be a
model of class \code{glm} or \code{glmer}, both of which require a predicted
poisson variable under a log link, or a model of class \code{lm} or
\code{lmer}, in which a Gaussian response is assumed. If given, then will
overwrite any juvenile size model given in \code{modelsuite}. This model must
have been developed in a modeling exercise testing only the impacts of time
\emph{t}.}

\item{jrepst_model}{A linear model predicting reproduction probability of a 
mature individual that was immature in the previous year. This can be a model
of class \code{glm} or \code{glmer}, and requires a predicted binomial
variable under a logit link. If given, then will overwrite any reproduction
probability model given in \code{modelsuite}. This model must have been
developed in a modeling exercise testing only the impacts of time \emph{t}.}

\item{paramnames}{A dataframe with two columns, the first showing the general
model terms that will be used in matrix creation, and the second showing the
equivalent terms used in modeling. Only required if \code{modelsuite} is not 
supplied.}

\item{inda}{A numeric value to use for individual covariate a. Defaults to 0.}

\item{indb}{A numeric value to use for individual covariate b. Defaults to 0.}

\item{indc}{A numeric value to use for individual covariate c. Defaults to 0.}

\item{surv_dev}{A numeric value to be added to the y-intercept in the linear
model for survival probability.}

\item{obs_dev}{A numeric value to be added to the y-intercept in the linear
model for observation probability.}

\item{size_dev}{A numeric value to be added to the y-intercept in the linear
model for size.}

\item{repst_dev}{A numeric value to be added to the y-intercept in the linear
model for probability of reproduction.}

\item{fec_dev}{A numeric value to be added to the y-intercept in the linear
model for fecundity.}

\item{jsurv_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile survival probability.}

\item{jobs_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile observation probability.}

\item{jsize_dev}{A numeric value to be added to the y-intercept in the linear
model for juvenile size.}

\item{jrepst_dev}{A numeric value to be added to the y-intercept in the
linear model for juvenile reproduction probability.}

\item{repmod}{A scalar multiplier of fecundity. Defaults to 1.}

\item{yearcol}{The variable name or column number corresponding to year in
time \emph{t} in the dataset. Not needed if a \code{modelsuite} is supplied.}

\item{patchcol}{The variable name or column number corresponding to patch in 
the dataset. Not needed if a \code{modelsuite} is supplied.}

\item{year.as.random}{A logical term indicating whether coefficients for
missing patches within vital rate models should be estimated as random
intercepts. Defaults to FALSE, in which case missing time step coefficients
are set to 0.}

\item{patch.as.random}{A logical term indicating whether coefficients for
missing patches within vital rate models should be estimated as random
intercepts. Defaults to FALSE, in which case missing patch coefficients are
set to 0.}

\item{final_age}{The final age to model in the matrix, where the first age
will be age 0.}

\item{continue}{A logical value designating whether to allow continued
survival of individuals going past the final age, using the demographic
characteristics of the final age.}

\item{randomseed}{A numeric value used as a seed to generate random estimates
for missing time step and patch coefficients, if either \code{year.as.random}
or \code{patch.as.random} is set to TRUE. Defaults to
\code{\link{set.seed}()} default.}

\item{negfec}{A logical value denoting whether fecundity values estimated to
be negative should be reset to 0. Defaults to FALSE.}

\item{reduce}{A logical value denoting whether to remove ahistorical stages
associated solely with 0 transitions. These are only removed in cases where
the associated row and column sums in ALL matrices estimated equal 0. 
Defaults to FALSE.}
}
\value{
If all inputs are properly formatted, then this function will return
an object of class \code{lefkoMat}. Output includes:

\item{A}{A list of full projection matrices in order of sorted patches and
years.}
\item{U}{A list of survival-transition matrices sorted as in \code{A}.}
\item{F}{A list of fecundity matrices sorted as in \code{A}.}
\item{hstages}{Null for ahistorical matrices.}
\item{ahstages}{A data frame detailing the characteristics of associated
ahistorical stages, in the form of a modified stageframe that includes
status as an entry stage through reproduction.}
\item{labels}{A data frame giving the patch and year of each matrix in order.
In \code{aflefko2()}, only one population may be analyzed at once, and so
\code{pop = NA}}
\item{matrixqc}{A short vector describing the number of non-zero elements
in \code{U} and \code{F} matrices, and the number of annual matrices.}
\item{modelqc}{This is the \code{qc} portion of the modelsuite input.}

Please note that this function will yield incorrect estimates if the models
utilized incorporate state in time \emph{t}-1. Only use models developed
testing ahistorical effects.
}
\description{
Function \code{aflefko2()} returns ahistorical age x stage MPMs corresponding
to the patches and years given, including the associated component transition
and fecundity matrices, a data frame detailing the characteristics of
ahistorical stages, and a data frame characterizing the patch and year
combinations corresponding to these matrices. Unlike \code{\link{rlefko2}()}
and \code{\link{rlefko3}()}, this function currently does not currently
distinguish populations.
}
\examples{
\donttest{
data(lathyrus)

sizevector <- c(0, 4.6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 1, 2, 3, 4, 5, 6, 7, 8,
  9)
stagevector <- c("Sd", "Sdl", "Dorm", "Sz1nr", "Sz2nr", "Sz3nr", "Sz4nr",
  "Sz5nr", "Sz6nr", "Sz7nr", "Sz8nr", "Sz9nr", "Sz1r", "Sz2r", "Sz3r",
  "Sz4r", "Sz5r", "Sz6r", "Sz7r", "Sz8r", "Sz9r")
repvector <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1)
obsvector <- c(0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0)
indataset <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
minima <- c(0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
maxima <- c(NA, 1, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
  NA, NA, NA, NA, NA)
binvec <- c(0, 4.6, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5,
  0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5)

lathframeln <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector, minage = minima, maxage = maxima)

lathvertln <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "lnVol88", repstracol = "Intactseed88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframeln,
  stagesize = "sizea", censorcol = "Missing1988", censorkeep = NA,
  NAas0 = TRUE, censor = TRUE)

lathvertln$feca2 <- round(lathvertln$feca2)
lathvertln$feca1 <- round(lathvertln$feca1)
lathvertln$feca3 <- round(lathvertln$feca3)

lathrepmln <- matrix(0, 21, 21)
lathrepmln[1, c(13:21)] <- 0.345
lathrepmln[2, c(13:21)] <- 0.054

lathover2 <- overwrite(stage3 = c("Sd", "Sdl"), stage2 = c("Sd", "Sd"),
  givenrate = c(0.345, 0.054))

lathmodelsln2 <- modelsearch(lathvertln, historical = FALSE,
  approach = "lme4", suite = "main",
  vitalrates = c("surv", "obs", "size", "repst", "fec"), juvestimate = "Sdl",
  bestfit = "AICc&k", sizedist = "gaussian", fecdist = "poisson",
  indiv = "individ", patch = "patchid", year = "year2", age = "obsage",
  year.as.random = TRUE, patch.as.random = TRUE, show.model.tables = TRUE,
  quiet = TRUE)
                             
lathmat2age <- aflefko2(year = "all", patch = "all", 
  stageframe = lathframeln, modelsuite = lathmodelsln2, data = lathvertln,
  repmatrix = lathrepmln, overwrite = lathover2, patchcol = "patchid",
  yearcol = "year2", year.as.random = FALSE, patch.as.random = FALSE,
  final_age = 2, continue = TRUE, reduce = FALSE)

summary(lathmat2age)
}

}
