% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jsFunctions.R, R/mapUtils.R
\name{propsToHTML}
\alias{propsToHTML}
\alias{propstoHTMLTable}
\alias{setMapWidgetStyle}
\title{Converts GeoJSON Feature properties to HTML}
\usage{
propsToHTML(props, elem = NULL, elem.attrs = NULL)

propstoHTMLTable(props = NULL, table.attrs = NULL, drop.na = TRUE)

setMapWidgetStyle(map, style = list(background = "transparent"))
}
\arguments{
\item{props}{A list of GeoJSON Property Keys.}

\item{elem}{An optional wrapping element e.g. "div".}

\item{elem.attrs}{An optional named list for the wrapper element properties.}

\item{table.attrs}{An optional named list for the HTML Table.}

\item{drop.na}{whether to skip properties with empty values.}

\item{map}{the map widget}

\item{style}{a A list of CSS key/value properties.}
}
\description{
Converts GeoJSON Feature properties to HTML

Converts GeoJSON Feature properties to HTML Table.

Customize the leaflet widget style
}
\examples{
\donttest{geoJson <- jsonlite::fromJSON(readr::read_file(
  paste0(
    "https://raw.githubusercontent.com/MinnPost/simple-map-d3",
    "/master/example-data/world-population.geo.json"
  )
))

world <- leaflet(
  options = leafletOptions(
    maxZoom = 5,
    crs = leafletCRS(
      crsClass = "L.Proj.CRS", code = "ESRI:53009",
      proj4def = "+proj=moll +lon_0=0 +x_0=0 +y_0=0 +a=6371000 +b=6371000 +units=m +no_defs",
      resolutions = c(65536, 32768, 16384, 8192, 4096, 2048)))) \%>\%
  addGraticule(style = list(color = "#999", weight = 0.5, opacity = 1, fill = NA)) \%>\%
  addGraticule(sphere = TRUE, style = list(color = "#777", weight = 1, opacity = 0.25, fill = NA))

world

# change background to white
world \%>\%
  setMapWidgetStyle(list(background = "white"))}


}
