% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-oxford_man_ts.R
\name{ldhmm.oxford_man_ts}
\alias{ldhmm.oxford_man_ts}
\title{Get time series from Oxford-Man Realized data set}
\usage{
ldhmm.oxford_man_ts(symbol, column, log = FALSE, to.vol = FALSE,
  days.pa = 252)
}
\arguments{
\item{symbol}{character, specify the index name, e.g. ".SPX".}

\item{column}{character, the column name, e.g. "rv5".}

\item{log}{logical, take one plus log to convert return to log-return. Default is \code{FALSE}.}

\item{to.vol}{logical, take \code{sqrt(x*252)*100} to convert variance to annualized volatility. Default is \code{FALSE}.}

\item{days.pa}{a positive integer specifying number of days to annualize volatility. Default is 252.}
}
\value{
an xts object containing the time series, with dates as index
}
\description{
This utility returns the time series from the specific column in Oxford-Man Realized data set.
}
\examples{
\dontrun{
    vol <- ldhmm.oxford_man_ts(".SPX", "rv5", to.vol=TRUE)
}
}
\author{
Stephen H. Lihn
}
\keyword{oxford}
