% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-calc_stats_from_obs.R
\name{ldhmm.calc_stats_from_obs}
\alias{ldhmm.calc_stats_from_obs}
\title{Computing the statistics for each state}
\usage{
ldhmm.calc_stats_from_obs(object, drop = 0, use.local = TRUE)
}
\arguments{
\item{object}{an ldhmm object}

\item{drop}{numeric, an integer to drop the largest N observations, default is zero.}

\item{use.local}{logical, use local decoding result, default is \code{TURE}. 
Otherwise, use global decoding result.}
}
\value{
an ldhmm object containing results of decoding
}
\description{
This utility computes the statistics (mean, sd, kurtosis, length) for each state.
It can be based on the local or global decoding result. The concept of asymptotic 
statistics can be applied by which the largest N observations (in absolute term)
can be dropped to avoid distortion from outliers. 
It is assumed the object already has come with filled data in 
\code{observations, states.prob, states.local, states.global} slots.
}
\author{
Stephen H. Lihn
}
\keyword{mllk}

