% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/liouville.R
\name{isliouvm_m}
\alias{isliouvm_m}
\title{Multiple marginal inverse survival function for Liouville copulas}
\usage{
isliouvm_m(u, family, alphavec, theta)
}
\arguments{
\item{u}{vector of survival probabilities}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{vector of Dirichlet allocations (must be a vector of integers)}

\item{theta}{parameter of the corresponding Archimedean copula}
}
\value{
a vector of same length as \code{u} with the quantile at 1-u
}
\description{
Multiple marginal inverse survival function for Liouville copulas
}
\examples{
u <- rliouv(n = 100, family = "clayton", alphavec <- c(2,3), theta = 2)
isliouvm_m(u=u, family="clayton", alphavec=c(2,3), theta=2)
}

