% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotControl.R
\name{plotControl}
\alias{plotControl}
\title{Specifying Graphical Control Values for \code{lcc} Class}
\usage{
plotControl(
  plot = TRUE,
  shape = 1,
  colour = "black",
  size = 0.5,
  xlab = "Time",
  ylab = "LCC"
)
}
\arguments{
\item{plot}{an optional to include an initial plot. If \code{TRUE},
the default, returns a \code{\link[ggplot2]{ggplot}} object with a
initial plot for \code{lcc} class. If \code{FALSE} never includes.}

\item{shape}{Draw points considering a shape parameter. Legal shape
values are the numbers 0 to 25, and 32 to 127; see
\code{\link[ggplot2]{aes_linetype_size_shape}}. Default is
\code{1}.}

\item{colour}{an specification for lines color. Default is
\code{"black"}.}

\item{size}{an specification for lines size. Should be specified
with a numerical value (in millimetres); see
\code{\link[ggplot2]{aes_linetype_size_shape}}. Default is
\code{0.5}.}

\item{xlab}{a title for the \code{x} axis.  Default is
\code{"Time"}.}

\item{ylab}{title for the \code{y} axis. Default is
\code{"LCC"}.}
}
\value{
a list with components for each of the possible arguments.
}
\description{
The values supplied in the \code{plotControl()} call
  replace the defaults, and a \code{\link{list}} with all settings
  is returned.
}
\author{
Thiago de Paula Oliveira, \email{thiago.paula.oliveira@usp.br}
}
\keyword{internal}
