% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explode.R
\name{lawn_explode}
\alias{lawn_explode}
\title{Explode vertices to points}
\usage{
lawn_explode(input, lint = FALSE)
}
\arguments{
\item{input}{\link{data-Feature} or \link{data-FeatureCollection}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-FeatureCollection} of points
}
\description{
Takes a feature or set of features and returns all positions as points
}
\examples{
poly <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "Polygon",
   "coordinates": [[
     [177.434692, -17.77517],
     [177.402076, -17.779093],
     [177.38079, -17.803937],
     [177.40242, -17.826164],
     [177.438468, -17.824857],
     [177.454948, -17.796746],
     [177.434692, -17.77517]
    ]]
 }
}'
lawn_explode(poly)
\dontrun{
lawn_data$polygons_average \%>\% view
lawn_explode(lawn_data$polygons_average) \%>\% view
lawn_data$polygons_within \%>\% view
lawn_explode(lawn_data$polygons_within) \%>\% view
}
}
