% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/along.R
\name{lawn_along}
\alias{lawn_along}
\title{Get a point at a distance along a line}
\usage{
lawn_along(line, distance, units, lint = FALSE)
}
\arguments{
\item{line}{input \code{\link{data-LineString}}}

\item{distance}{distance along the line}

\item{units}{can be degrees, radians, miles (default), or kilometers}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing time
as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good geojson
objects. Default: \code{FALSE}}
}
\value{
\code{\link{data-Point}} distance units along the line
}
\description{
Takes a \code{\link{data-LineString}} and returns a \code{\link{data-Point}}
at a specified distance along the line.
}
\examples{
pts <- '[
   [-21.964416, 64.148203],
   [-21.956176, 64.141316],
   [-21.93901, 64.135924],
   [-21.927337, 64.136673]
]'
lawn_along(lawn_linestring(pts), 1, 'miles')
}
\seealso{
Other measurements: \code{\link{lawn_area}},
  \code{\link{lawn_bbox_polygon}}, \code{\link{lawn_bbox}},
  \code{\link{lawn_bearing}}, \code{\link{lawn_center}},
  \code{\link{lawn_centroid}},
  \code{\link{lawn_destination}},
  \code{\link{lawn_distance}}, \code{\link{lawn_envelope}},
  \code{\link{lawn_extent}},
  \code{\link{lawn_line_distance}},
  \code{\link{lawn_midpoint}},
  \code{\link{lawn_point_on_surface}},
  \code{\link{lawn_square}}
}

