% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utils-nlme.R
\name{getVarCov2-internal}
\alias{getVarCov2-internal}
\alias{.getVarCov2}
\alias{.getVarCov2.gls}
\alias{.getVarCov2.lme}
\title{Reconstruct the Marginal Variance Covariance Matrix from a nlme Model}
\usage{
.getVarCov2(object, ...)

\method{.getVarCov2}{gls}(object, param, attr.param, name.endogenous,
  n.endogenous, ref.group, ...)

\method{.getVarCov2}{lme}(object, param, attr.param, ...)
}
\arguments{
\item{object}{a \code{gls} or \code{lme} object}

\item{...}{[internal] Only used by the generic method.}

\item{param}{[numeric vector] the mean and variance coefficients.}

\item{attr.param}{[character vector] the type of each coefficients (mean or variance).}

\item{name.endogenous}{[character vector] name of each repetition of the endogenous variable.}

\item{n.endogenous}{[integer >0] number of repetitions of the endogenous variable.}

\item{ref.group}{[character vector] the levels of the variable defining the variance component in a generic covariance matrix.}
}
\value{
[matrix] the marginal variance covariance matrix for a full sample.
}
\description{
Reconstruct the marginal variance covariance matrix from a nlme model.
}
\concept{extractor}
\keyword{internal}
