% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/regression.R
\name{regression<-}
\alias{regfix}
\alias{regfix.lvm}
\alias{regfix<-}
\alias{regfix<-.lvm}
\alias{regression}
\alias{regression.lvm}
\alias{regression<-}
\alias{regression<-.lvm}
\title{Add regression association to latent variable model}
\usage{
\method{regression}{lvm}(object = lvm(), to, from, fn = NA,
silent = lava.options()$silent, additive=TRUE, y, x, ...)
\method{regression}{lvm}(object, to=NULL, quick=FALSE, ...) <- value
}
\arguments{
\item{object}{\code{lvm}-object.}

\item{value}{A formula specifying the linear constraints or if
\code{to=NULL} a \code{list} of parameter values.}

\item{to}{Character vector of outcome(s) or formula object.}

\item{from}{Character vector of predictor(s).}

\item{fn}{Real function defining the functional form of predictors (for
simulation only).}

\item{silent}{Logical variable which indicates whether messages are turned
on/off.}

\item{additive}{If FALSE and predictor is categorical a non-additive effect is assumed}

\item{y}{Alias for 'to'}

\item{x}{Alias for 'from'}

\item{quick}{Faster implementation without parameter constraints}

\item{\dots}{Additional arguments to be passed to the low level functions}
}
\value{
A \code{lvm}-object
}
\description{
Define regression association between variables in a \code{lvm}-object and
define linear constraints between model equations.
}
\details{
The \code{regression} function is used to specify linear associations
between variables of a latent variable model, and offers formula syntax
resembling the model specification of e.g. \code{lm}.

For instance, to add the following linear regression model, to the
\code{lvm}-object, \code{m}:
\deqn{ E(Y|X_1,X_2) = \beta_1 X_1 + \beta_2 X_2}
We can write

\code{regression(m) <- y ~ x1 + x2}

Multivariate models can be specified by successive calls with
\code{regression}, but multivariate formulas are also supported, e.g.

\code{regression(m) <- c(y1,y2) ~ x1 + x2}

defines
\deqn{ E(Y_i|X_1,X_2) = \beta_{1i} X_1 + \beta_{2i} X_2 }

The special function, \code{f}, can be used in the model specification to
specify linear constraints. E.g. to fix \eqn{\beta_1=\beta_2}
, we could write

\code{regression(m) <- y ~ f(x1,beta) + f(x2,beta)}

The second argument of \code{f} can also be a number (e.g. defining an
offset) or be set to \code{NA} in order to clear any previously defined
linear constraints.

Alternatively, a more straight forward notation can be used:

\code{regression(m) <- y ~ beta*x1 + beta*x2}

All the parameter values of the linear constraints can be given as the right
handside expression of the assigment function \code{regression<-} (or
\code{regfix<-}) if the first (and possibly second) argument is defined as
well. E.g:

\code{regression(m,y1~x1+x2) <- list("a1","b1")}

defines \eqn{E(Y_1|X_1,X_2) = a1 X_1 + b1 X_2}. The rhs argument can be a
mixture of character and numeric values (and NA's).

The function \code{regression} (called without additional arguments) can be
used to inspect the linear constraints of a \code{lvm}-object.

For backward compatibility the "$"-symbol can be used to fix parameters at
a given value. E.g. to add a linear relationship between \code{y} and
\code{x} with slope 2 to the model \code{m}, we can write
\code{regression(m,"y") <- "x$2"}.  Similarily we can use the "@"-symbol to
name parameters. E.g. in a multiple regression we can force the parameters
to be equal: \code{regression(m,"y") <- c("x1@b","x2@b")}.  Fixed parameters
can be reset by fixing (with \$) them to \code{NA}.
}
\note{
Variables will be added to the model if not already present.
}
\examples{
m <- lvm() ## Initialize empty lvm-object
### E(y1|z,v) = beta1*z + beta2*v
regression(m) <- y1 ~ z + v
### E(y2|x,z,v) = beta*x + beta*z + 2*v + beta3*u
regression(m) <- y2 ~ f(x,beta) + f(z,beta)  + f(v,2) + u
### Clear restriction on association between y and
### fix slope coefficient of u to beta
regression(m, y2 ~ v+u) <- list(NA,"beta")

regression(m) ## Examine current linear parameter constraints

## ## A multivariate model, E(yi|x1,x2) = beta[1i]*x1 + beta[2i]*x2:
m2 <- lvm(c(y1,y2) ~ x1+x2)
}
\author{
Klaus K. Holst
}
\seealso{
\code{\link{intercept<-}}, \code{\link{covariance<-}},
\code{\link{constrain<-}}, \code{\link{parameter<-}},
\code{\link{latent<-}}, \code{\link{cancel<-}}, \code{\link{kill<-}}
}
\keyword{models}
\keyword{regression}

