##' Generic method for adding variables to model object
##'
##' @title Add variable to (model) object 
##' @param x Model object
##' @param ... Additional arguments
##' @author Klaus K. Holst
##' @aliases addvar<-
##' @export
`addvar` <-
function(x,...) UseMethod("addvar")
##' @export
`addvar<-` <-
function(x,...,value) UseMethod("addvar<-")

##' @S3method addvar<- lvm
`addvar<-.lvm` <-function(x,...,value) {
  if (class(value)[1]=="formula") {
    regression(x,...) <- value
    return(x)
##    return(addvar(x,all.vars(value),...))
  }
  addvar(x, var=value, ...)
}

##' @S3method addvar lvm
`addvar.lvm` <-
function(x, var, silent=lava.options()$silent,...) {
  new <- setdiff(var,vars(x))
  Debug(new)
  if (length(new)>0)
    for (i in new) {
      N <- nrow(x$cov)
      if (is.null(N)) {
        N <- 0
        x$M <- matrix(0)
        x$cov <- matrix(1); x$covfix <- x$fix <- x$par <- x$covpar <- matrix(NA)
        x$mean <- list(NA)
      } else {
        x$M <- rbind(cbind(x$M, rep(0,N)), rep(0,N+1)); ## Add regression labels
        x$par <- rbind(cbind(x$par, rep(NA,N)), rep(NA,N+1)); ## Add regression labels
        x$covpar <- rbind(cbind(x$covpar, rep(NA,N)), rep(NA,N+1)); ## Add covariance labels
        x$cov <- rbind(cbind(x$cov, rep(0,N)), rep(0,N+1)); ## Add covariance
        x$fix <- rbind(cbind(x$fix, rep(NA,N)), rep(NA,N+1)); ##
        x$covfix <- rbind(cbind(x$covfix, rep(NA,N)), rep(NA,N+1)); ##
        x$mean <- c(x$mean, NA)
      }
      x$cov[N+1,N+1] <- 1
      names(x$mean)[N+1] <-
        colnames(x$M)[N+1] <- rownames(x$M)[N+1] <-
        colnames(x$covfix)[N+1] <- rownames(x$covfix)[N+1] <-
          colnames(x$fix)[N+1] <- rownames(x$fix)[N+1] <-
            colnames(x$covpar)[N+1] <- rownames(x$covpar)[N+1] <-               
              colnames(x$par)[N+1] <- rownames(x$par)[N+1] <- 
                colnames(x$cov)[N+1] <- rownames(x$cov)[N+1] <- i
      myexpr <- paste("c(",i,"=expression(",i,"))", sep="\"")
      labels(x) <- (eval(parse(text=myexpr)))
      if (!silent)
        message("\tAdded '", i, "' to model.\n", sep="")
    }
##  index(m) <- reindex(m)
  return(x)
}
