% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{getLabel}
\alias{getLabel}
\alias{getLabel,lcMethod-method}
\alias{getLabel,lcModel-method}
\title{Extract the method label.}
\usage{
\S4method{getLabel}{lcMethod}(object, ...)

\S4method{getLabel}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcMethod} or \code{lcModel} object.}

\item{...}{Additional arguments.}
}
\value{
The extracted label, as \code{character}.
}
\description{
Extracts the assigned label from the given \code{lcMethod} or \code{lcModel} object.
By default, the label is determined from the \code{"label"} argument of the \code{lcMethod} object.
The label of an \code{lcModel} object is set upon estimation by \code{\link[=latrend]{latrend()}} to the label of its associated \code{lcMethod} object.
}
\examples{
method <- lcMethodLMKM(Y ~ Time, time = "Time")
getLabel(method) # ""

getLabel(update(method, label = "v2")) # "v2"
}
\seealso{
\link{getName} \link{getShortName}
}
