% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{evaluate.lcMethod}
\alias{evaluate.lcMethod}
\title{Substitute the call arguments for their evaluated values}
\usage{
\method{evaluate}{lcMethod}(
  object,
  classes = "ANY",
  try = TRUE,
  exclude = character(),
  envir = NULL
)
}
\arguments{
\item{object}{The \code{lcMethod} object.}

\item{classes}{Substitute only arguments with specific class types. By default, all types are substituted.}

\item{try}{Whether to try to evaluate arguments and ignore errors (the default), or to fail on any argument evaluation error.}

\item{exclude}{Arguments to exclude from evaluation.}

\item{envir}{The \code{environment} in which to evaluate the arguments. If \code{NULL}, the environment associated with the object is used. If not available, the \code{parent.frame()} is used.}
}
\value{
A new \code{lcMethod} object with the substituted arguments.
}
\description{
Substitutes the call arguments if they can be evaluated without error.
}
\seealso{
\link{compose}

Other lcMethod functions: 
\code{\link{[[,lcMethod-method}},
\code{\link{as.data.frame.lcMethods}()},
\code{\link{as.data.frame.lcMethod}()},
\code{\link{as.lcMethods}()},
\code{\link{as.list.lcMethod}()},
\code{\link{formula.lcMethod}()},
\code{\link{lcMethod-class}},
\code{\link{names,lcMethod-method}},
\code{\link{update.lcMethod}()}
}
\concept{lcMethod functions}
