% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latexdiff.R
\name{git_latexdiff}
\alias{git_latexdiff}
\title{Call latexdiff on git revisions}
\usage{
git_latexdiff(path, revision, clean = TRUE, ...)
}
\arguments{
\item{path}{File path to diff}

\item{revision}{Revision, specified in a form that \code{git} understands. See
\verb{man gitrevisions}}

\item{clean}{Clean up intermediate files, including the checked out file?}

\item{...}{Arguments passed to \code{\link[=latexdiff]{latexdiff()}}}
}
\value{
The result of \code{latexdiff}.
}
\description{
\code{git_latexdiff()} checks out a previous version of a file and calls latexdiff
on it.
}
\details{
\code{git_latexdiff} only checks out the specific file in \code{path}. If your Rmd file depends on external
resources which have also changed, you will need to checkout the old revision as a whole and
create the tex file manually.
}
\examples{
\dontrun{
git_latexdiff("file1.Rmd", "HEAD^")
git_latexdiff("file1.Rmd", "master@{7 days ago}")
}
}
