% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{saveList}
\alias{saveList}
\title{Save or append elements to a list file.}
\usage{
saveList(object, file, append = FALSE, compress = TRUE)
}
\arguments{
\item{object}{A list object to save or append.}

\item{file}{Name of file.}

\item{append}{\code{TRUE/FALSE}, \code{TRUE} refers to truncating and saving. 
\code{FALSE} refers to appending.}

\item{compress}{\code{TRUE/FALSE}, using compression or not.}
}
\value{
invisible \code{TRUE} if no error occurs.
}
\description{
Save or append elements to a list file.
}
\details{
Save or append a list (with or without names) to a file.
Notice that, all names will be truncated to 16 characters. Rest attributes of lists
will be discarded. \cr
Files generated by this function are not readable by \code{\link{readRDS}}. \cr
When it takes long time to process, some verbose info will be printed to console, 
which can be switched off by setting \code{options(list(largeList.report.progress = FALSE))}.
}
\examples{
list_1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))

# save list_1 to file using compression.
saveList(object = list_1, file = "example.llo", append = FALSE, compress = TRUE)

# append list_1 to file, compress option will be extracted from the file.
saveList(object = list_1, file = "example.llo", append = TRUE)

}
\seealso{
\code{\link{largeList}}
}
