% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini.R
\name{gemini_ask}
\alias{gemini_ask}
\alias{gemini_image}
\title{Gemini API Interaction with R}
\usage{
gemini_ask(
  ask,
  secret_key = get_creds("gemini")$api_key,
  url = Sys.getenv("LARES_GEMINI_API"),
  temperature = 0.5,
  max_tokens = 1024,
  quiet = FALSE,
  ...
)

gemini_image(
  ask,
  image,
  secret_key = get_creds("gemini")$api_key,
  url = Sys.getenv("LARES_GEMINI_API"),
  temperature = 0.5,
  max_tokens = 1024,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{ask}{Character. Redacted prompt to ask. If multiple asks are
requested, they will be concatenated with "+" into a single request.}

\item{secret_key}{Character. Secret Key. Get yours in:
\href{https://platform.openai.com}{platform.openai.com} for OpenAI or
\href{https://makersuite.google.com/app/apikey}{makersuite.google.com}
for Gemini.}

\item{url}{Character. Base API URL.}

\item{temperature}{Numeric. The temperature to use for generating
the response. Default is 0.5. The lower the \code{temperature},
the more deterministic the results in the sense that the highest probable
next token is always picked. Increasing temperature could lead to more
randomness, which encourages more diverse or creative outputs. You are
essentially increasing the weights of the other possible tokens.
In terms of application, you might want to use a lower temperature value
for tasks like fact-based QA to encourage more factual and concise responses.
For poem generation or other creative tasks, it might be beneficial to
increase the temperature value.}

\item{max_tokens}{Integer. The maximum number of tokens in the response.}

\item{quiet}{Boolean. Keep quiet? If not, message will be shown.}

\item{...}{Additional parameters.}

\item{image}{Character. Data to be encoded/decoded. It can be a raw vector,
text connection or file name.}
}
\value{
(Invisible) list. Content returned from API POST and processed.
}
\description{
This function lets the user interact with Google's Gemini LLM Model using
its API, and returns the rendered reply.
}
\examples{
\dontrun{
api_key <- get_credentials()$gemini$api_key
# Open question:
gemini_ask("Can you write an R function to plot a dummy histogram?", api_key)
# Image question
image <- "man/figures/automl_map.png"
gemini_image("Can you explain this flow with more detail?", image, api_key)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_process}()},
\code{\link{fb_report_check}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{gpt_ask}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other LLM: 
\code{\link{gpt_ask}()},
\code{\link{gpt_prompter}()}
}
\concept{API}
\concept{Gemini}
\concept{LLM}
