% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{splot_roi}
\alias{splot_roi}
\title{Portfolio Plots: Daily ROI}
\usage{
splot_roi(p, n_days = 365, historical = TRUE, ma = c(12, 50), save = FALSE)
}
\arguments{
\item{p}{Dataframe. Result from \code{daily_portfolio()}}

\item{n_days}{Integer. How many days back you want to see?}

\item{historical}{Boolean. Historical ROI metric? If not, ROI
will be calculated locally for n_days parameter}

\item{ma}{Numeric Vector. Select 2 values for moving averages.
Set to NA to turn this metric off}

\item{save}{Boolean. Save plot into a local file?}
}
\value{
ggplot object
}
\description{
This function plots a portfolio's historical ROI since inception
or since last n days, with 2 moving average lines.
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}

Other Investment Plots: 
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()}
}
\concept{Investment}
\concept{Investment Plots}
