% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{vector2text}
\alias{vector2text}
\alias{v2t}
\title{Convert a vector into a comma separated text}
\usage{
vector2text(vector, sep = ", ", quotes = TRUE, and = "")

v2t(vector, sep = ", ", quotes = TRUE, and = "")
}
\arguments{
\item{vector}{Vector. Vector with more than 1 observation.}

\item{sep}{Character. String text wished to insert between values.}

\item{quotes}{Boolean. Bring simple quotes for each observation.}

\item{and}{Character. Add 'and' or something before last observation. 
Not boolean variable so it can be used on other languages. Note that
the last comma will be suppressed if \code{Sys.getenv("LARES_NUMFORMAT")}
is set to \code{1} and you have less than 3 values.}
}
\value{
Vector pasting \code{vector} values into a single string
}
\description{
Convert a vector into a comma separated text
}
\examples{
vector2text(LETTERS[1:5])
vector2text(c(1:5), quotes = FALSE)
vector2text(c(1:5), quotes = FALSE, sep = "-")
vector2text(c(1:5), and = "and also")
# Shorter function with same purpose
v2t(LETTERS[1:5])
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{year_month}()},
\code{\link{year_week}()}
}
\concept{Data Wrangling}
