% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_enn_sd.R
\name{lsm_l_enn_sd}
\alias{lsm_l_enn_sd}
\title{ENN_SD (landscape level)}
\usage{
lsm_l_enn_sd(landscape, directions = 8, verbose = TRUE)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}

\item{verbose}{Print warning message if not sufficient patches are present}
}
\value{
tibble
}
\description{
Standard deviation of euclidean nearest-neighbor distance (Aggregation metric)
}
\details{
\deqn{ENN_{SD} = sd(ENN[patch_{ij}])}
where \eqn{ENN[patch_{ij}]} is the euclidean nearest-neighbor distance
of each patch.

ENN_CV is an 'Aggregation metric'. It summarises in the landscape as the standard
deviation of all patches in the landscape. ENN measures the distance to the  nearest
neighbouring patch of the same class i. The distance is measured from edge-to-edge.
The range is limited by the cell resolution on the lower limit and the landscape extent
on the upper limit. The metric is a simple way to describe patch isolation. Because it is
scaled to the mean, it is easily comparable among different landscapes.

\subsection{Units}{Meters}
\subsection{Range}{ENN_SD >= 0}
\subsection{Behaviour}{Equals ENN_SD = 0 if the euclidean nearest-neighbor distance is
identical for all patches. Increases, without limit, as the variation of ENN increases.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_enn_sd(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

McGarigal, K., and McComb, W. C. (1995). Relationships between landscape
structure and breeding birds in the Oregon Coast Range.
Ecological monographs, 65(3), 235-260.
}
\seealso{
\code{\link{lsm_p_enn}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_enn_mn}},
\code{\link{lsm_c_enn_sd}},
\code{\link{lsm_c_enn_cv}}, \cr
\code{\link{lsm_l_enn_mn}},
\code{\link{lsm_l_enn_cv}}
}
