% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_ent.R
\name{lsm_l_ent}
\alias{lsm_l_ent}
\alias{lsm_l_ent.RasterLayer}
\alias{lsm_l_ent.RasterStack}
\alias{lsm_l_ent.RasterBrick}
\alias{lsm_l_ent.stars}
\alias{lsm_l_ent.list}
\title{ENT (landscape level)}
\usage{
lsm_l_ent(landscape, neighbourhood, base)

\method{lsm_l_ent}{RasterLayer}(landscape, neighbourhood = 4, base = "log2")

\method{lsm_l_ent}{RasterStack}(landscape, neighbourhood = 4, base = "log2")

\method{lsm_l_ent}{RasterBrick}(landscape, neighbourhood = 4, base = "log2")

\method{lsm_l_ent}{stars}(landscape, neighbourhood = 4, base = "log2")

\method{lsm_l_ent}{list}(landscape, neighbourhood = 4, base = "log2")
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{base}{The unit in which entropy is measured.
The default is "log2", which compute entropy in "bits".
"log" and "log10" can be also used.}
}
\value{
tibble
}
\description{
Marginal entropy \[H(x)\]
}
\details{
It measures a diversity (thematic complexity) of landscape classes.
}
\examples{
lsm_l_ent(landscape)

}
\references{
Nowosad J., TF Stepinski. 2019. Information theory as a consistent framework
for quantification and classification of landscape patterns. https://doi.org/10.1007/s10980-019-00830-x
}
\seealso{
\code{\link{lsm_l_condent}},
\code{\link{lsm_l_mutinf}},
\code{\link{lsm_l_joinent}},
}
