% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_cai_sd.R
\name{lsm_l_cai_sd}
\alias{lsm_l_cai_sd}
\alias{lsm_l_cai_sd.RasterLayer}
\alias{lsm_l_cai_sd.RasterStack}
\alias{lsm_l_cai_sd.RasterBrick}
\alias{lsm_l_cai_sd.list}
\title{CAI_SD (landscape level)}
\usage{
lsm_l_cai_sd(landscape, directions)

\method{lsm_l_cai_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_cai_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_l_cai_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_cai_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation of core area index (Core area metric)
}
\details{
\deqn{CAI_{SD} = sd(CAI[patch_{ij}]}
where \eqn{CAI[patch_{ij}]} is the core area index of each patch.

CAI_SD is a 'Core area metric'. The metric summarises the landscape
as the standard deviation of the core area index of all patches in the landscape.
The core area index is the percentage of core area in relation to patch area.
A cell is defined as core area if the cell has no neighbour with a different
value than itself (rook's case). The metric describes the differences among all patches
in the landscape.

\subsection{Units}{Percent}
\subsection{Range}{CAI_SD >= 0}
\subsection{Behaviour}{Equals CAI_SD = 0 if the core area index is identical for
all patches. Increases, without limit, as the variation of core area
indices increases.}
}
\examples{
lsm_l_cai_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html
}
\seealso{
\code{\link{lsm_p_cai}},
\code{\link{sd}}, \cr
\code{\link{lsm_c_cai_mn}},
\code{\link{lsm_c_cai_sd}},
\code{\link{lsm_c_cai_cv}}, \cr
\code{\link{lsm_l_cai_mn}},
\code{\link{lsm_l_cai_cv}}
}
