% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/land8tools.R
\name{reflconvS}
\alias{reflconvS}
\title{Conversion to TOA Reflectance with a Correction for the Sun Angle}
\usage{
reflconvS(x, Mp, Ap, sunelev)
}
\arguments{
\item{x}{Image to be converted, in matrix, data frame, or SpatialGridDataFrame format.}

\item{Mp}{band specific multiplicative rescaling factor from the metadata (MTL file) (REFLECTANCE_MULT_BAND_x, where x is the band number).}

\item{Ap}{band specific additive rescaling factor from the metadata (MTL file) (REFLECTANCE_ADD_BAND_x, where x is the band number).}

\item{sunelev}{Sun elevation in degrees is provided in the metadata (MTL file) (SUN_ELEVATION).}
}
\value{
TOA spectral radiance with a correction for the sun angle.
}
\description{
Conversion to TOA reflectance with a correction for the sun angle of satellite data.
}
\examples{
data(band5)
band5.dn<- as(band5, 'SpatialGridDataFrame')
band5.reflS<-reflconvS(band5.dn,2.0000E-05,-0.100000,41.12846745)
}
\author{
Alexandre dos Santos
}
\references{
U.S. Geological Survey. 2015.
            Landsat 8 (L8) data users handbook. Version 1.0. 97p.
}

