% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindStructure.R
\name{FindStructure}
\alias{FindStructure}
\title{Find the structure of the graph from the adjacency matrix}
\usage{
FindStructure(A)
}
\arguments{
\item{A}{The adjacency matrix}
}
\value{
A list with the following elements:
\itemize{
\item{\code{graph}}{ igraph object derived from A,}
\item{\code{groups}}{ List of connected components and corresponding nodes.}
}
}
\description{
This internal function of the spectral clustering algorithm finds the structure of the graph to cluster (number of nodes and connected components).
}
\examples{
 ###############################################################
 # Finding the structure of the graph from the adjacency matrix
 ###############################################################

 # 1st example: non-perturbed graph
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0,p_outside=0))

 Structure <- FindStructure(Data$A_hat)
 Structure$groups # the graph is not perturbed, there are 3 connected components

 # 2nd example: highly-perturbed graph
 Data <- CreateDataSet(k=3, n=20, p=list(p_inside=0.5,p_outside=0.5))

 Structure <- FindStructure(Data$A_hat)
 Structure$groups # the graph is higlhy perturbed, there are less than 3 connected components
}
\seealso{
\code{\link{l1_spectralclustering}}, \code{\link{l1spectral}}.
}
\author{
Camille Champion, Magali Champion
}
