% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{kzpdr.valid}
\alias{kzpdr.valid}
\title{Validate Estimated Wave Parameters Under Given Tolerance Setting}
\usage{
kzpdr.valid(rec = ls(1), t.D = 2, t.F = 0.01, level = 1)
}
\arguments{
\item{rec}{Data list from the outputs of function \code{kzpdr}. It includes the
data frame for the marked frequency values and corresponding directions.
Defaults is searching for available records in the environment.}

\item{t.D}{Tolerance of direction in degree. Default is 2.}

\item{t.F}{Tolerance of frequency. Default value is 0.01.}

\item{level}{\code{level} control the cross-validation process:
integer number \code{k} means to run cross-validation by excluding 
\code{k} pairs of directional samples each time. Default value is 1.}
}
\description{
For a given tolerance setting, \code{kzpdr.valid} will provide cross-validation 
information for related results of wave parameter estimations.
}
\details{
Due to the nosies or other reasons, there may exist fake spike signals in 
the directional periodograms. Cross-validation will evaluate estimations by 
excluding one or few measurements, and identify the data points that casued 
inconsistent estimations. A table will be given to summarize the validation
results.

    For a given tolerance setting, if the validation shows consistent results,
	related estimation would be reliable.
}
\examples{

# load pre-saved data 
data(kzpdr.demo)

# validation
kzpdr.valid(kzpdr.demo, t.D = 2, t.F = 0.01, level = 1)
}
\seealso{
\code{\link{kzpdr}}, \code{\link{kzpdr.eval}}, \code{\link{kzpdr.tol}}
}
\concept{directional periodogram}
\keyword{directional-periodogram}
