% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsicclust.R
\name{hsic.clust}
\alias{hsic.clust}
\title{HSIC cluster permutation conditional independence test}
\usage{
hsic.clust(x, y, z, sig = 1, p = 100, numCluster = 10, numCol = 50,
  eps = 0.1, paral = 1)
}
\arguments{
\item{x}{first variable}

\item{y}{second variable}

\item{z}{set of variables on which we condition}

\item{sig}{the with of the Gaussian kernel}

\item{p}{the number of permutations}

\item{numCluster}{number of clusters for clustering z}

\item{numCol}{maximum number of columns that we use for the incomplete Cholesky decomposition}

\item{eps}{normalization parameter for HSIC cluster test}

\item{paral}{number of cores used}
}
\value{
hsic.clust() returns a list with class htest containing
\item{method}{description of test}
\item{statistic}{observed value of the test statistic}
\item{estimate}{HSIC(x,y)}
\item{estimates}{a vector: [HSIC(x,y), mean of HSIC(x,y), variance of HSIC(x,y)]}
\item{replicates}{replicates of the test statistic}
\item{p.value}{approximate p-value of the test}
\item{data.name}{desciption of data}
}
\description{
Conditional independence test using HSIC and permutation with clusters.
}
\details{
Let x and y be two samples of length n. Gram matrices K and L are defined as: \eqn{K_{i,j} = \exp\frac{(x_i-x_j)^2}{\sigma^2}}{K_{i,j} =exp((x_i-x_j)^2/sig^2)}, \eqn{L_{i,j} = \exp\frac{(y_i-y_j)^2}{\sigma^2}}{L_{i,j} =exp((y_i-y_j)^2/sig^2)} and \eqn{M_{i,j} = \exp\frac{(z_i-z_j)^2}{\sigma^2}}{M_{i,j} =exp((z_i-z_j)^2/sig^2)}. \eqn{H_{i,j} = \delta_{i,j} - \frac{1}{n}}{H_{i,j} = delta_{i,j} - 1/n}. Let \eqn{A=HKH}, \eqn{B=HLH} and \eqn{C=HMH}. \eqn{HSIC(X,Y|Z) = \frac{1}{n^2}Tr(AB-2AC(C+\epsilon I)^{-2}CB+AC(C+\epsilon I)^{-2}CBC(C+\epsilon I)^{-2}C)}{HSIC(X,Y|Z) = Tr(AB-2AC(C+\epsilon I)^{-2}CB+AC(C+\epsilon I)^{-2}CBC(C+\epsilon I)^{-2}C)/n^2}. Permutation test clusters Z and then permutes Y in the clusters of Z p times to get \eqn{Y_{(p)}} and calculates \eqn{HSIC(X,Y_{(p)}|Z)}. \eqn{pval = \frac{1(HSIC(X,Y|Z)>HSIC(Z,Y_{(p)}|Z))}{p}}{(HSIC(X,Y|Z)>HSIC(X,Y_{(p)}|Z))/p}.
}
\examples{
library(energy)
set.seed(10)
# x and y dependent, but independent conditionally on z
z <- 10*runif(300)
x <- sin(z) + runif(300)
y <- cos(z) + runif(300)
plot(x,y)
hsic.gamma(x,y)
hsic.perm(x,y)
dcov.test(x,y)
hsic.clust(x,y,z)
}
\author{
Petras Verbyla (\email{petras.verbyla@mrc-bsu.cam.ac.uk}) and Nina Ines Bertille Desgranges
}
\references{
Tillman, R. E., Gretton, A. and Spirtes, P. (2009). Nonlinear directed acyclic structure learning with weakly additive noise model. NIPS 22, Vancouver.

K. Fukumizu et al. (2007). Kernel Measures of Conditional Dependence. NIPS 20. \url{https://papers.nips.cc/paper/3340-kernel-measures-of-conditional-dependence.pdf}
}
\seealso{
\link{hsic.gamma}, \link{hsic.perm}, \link{kernelCItest}
}

