% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frmladditivesmooth.R
\name{frml.additive.smooth}
\alias{frml.additive.smooth}
\title{Formula for GAM without crossterms}
\usage{
frml.additive.smooth(target.ind, pred.inds, var.str = "x")
}
\arguments{
\item{target.ind}{integer, number for the variable to be regressed}

\item{pred.inds}{integer(s), number(s) for the variable(s) on which we regress}

\item{var.str}{name of variables used to create formula, default is "x"}
}
\value{
formula.additive.smooth() returns a formula \eqn{X_i \sim s(X_{n+1}) + ... + s(X_m)}{X_i ~ s(X_{n+1}) + ... + s(X_m)}
}
\description{
Creates a formula for \link{gam} to be used in \link{regrXonS}. For data \eqn{X=(X_1,...X_n,X_{n+1},...,X_m)}, variable to be regressed \eqn{X_{i}}, i=1...n and variables to regress on \eqn{S={X_{n+1},...,X_m}} creates formula \eqn{X_i \sim s(X_{n+1}) + ... + s(X_m)}{X_i ~ s(X_{n+1}) + ... + s(X_m)}.
}
\author{
Petras Verbyla (\email{petras.verbyla@mrc-bsu.cam.ac.uk})
}
\seealso{
\link{regrXonS}
}

