% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstudio_addins.R
\encoding{UTF-8}
\name{create_data_chunk_dialog}
\alias{create_data_chunk_dialog}
\title{Invoke Shiny gadget to create a data chunk}
\usage{
create_data_chunk_dialog(
  title = "Data chunk creator",
  infobar = "<big><b>Fill out, then click above to create chunk</b></big>"
)
}
\arguments{
\item{title}{Text to place in title bar of gadget}

\item{infobar}{HTML content to place in information bar at top of gadget}
}
\value{
Invisibly returns the text of the data chunk as a character vector, one line per element.
}
\description{
As different elements of the data chunk are specified, other options will be modified
as is likely to be useful. For example, if a binary file is uploaded, then the \code{format}
will be set to \code{binary}, the \code{encoding} will be set to \code{base64} and the
\code{Encode data?} option will be checked. If these options are not appropriate, then they can
be altered afterwards.
}
\details{
When the \code{Create chunk} button is clicked, the function will return the chunk contents
including header and tail.
}
\examples{
\dontrun{
create_data_chunk_dialog()
}

}
\seealso{
Other Chunk tools: 
\code{\link{create_chunk}()},
\code{\link{insert_data_chunk_dialog}()},
\code{\link{insert_data_chunk_template}()},
\code{\link{list_rmd_chunks}()},
\code{\link{remove_chunks_dialog}()}
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
\concept{Chunk tools}
