% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankkmed.R
\name{rankkmed}
\alias{rankkmed}
\title{Rank k-medoid algorithm from Zadegan et. al.}
\usage{
rankkmed(distdata, ncluster, m = 3, iterate = 10, initial = NULL)
}
\arguments{
\item{distdata}{A matrix of distance objects (n x n) or a diss class.}

\item{ncluster}{A number of cluster.}

\item{m}{A number of objects to compute hostility.}

\item{iterate}{A number of iteration for clustering algorithm.}

\item{initial}{A vector of initial objects as the cluster medoids.}
}
\value{
Function returns a partitioning clustering algorithm result consists of cluster
membership, cluster medoid, the minimum distance to the cluster medoid.
}
\description{
This function computes and returns the clustering result
computed by using a specified distance via rank k-medoids algorithm.
}
\details{
This is a k-medoids algorithm that has been proposed by Zadegan et. al. The algorihm
has been claimed to be suitable for large dataset. The medoids updating in this algorihm is
similar to kmeans centroid updating.
}
\examples{
num <- as.matrix(iris[,1:4])
mrwdist <- distNumeric(num, num, method = "mrw")
result <- fastkmed(mrwdist, ncluster = 3, iterate = 50)
table(result$cluster, iris[,5])


}
\references{
Zadegan, S.M.R, Mirzaie M, and Sadoughi, F. 2013. Ranked k-medoids: A fast and
accurate rank-based partitioning algorithm for clustering large datasets. Knowledge-Based
Systems 39, 133-143.
}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
