% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KinPairSimulation.R
\name{KinPairSimulation_composite}
\alias{KinPairSimulation_composite}
\title{Constructor for KinPairSimulation Class (composite)}
\usage{
KinPairSimulation_composite(
  data = NULL,
  kinship = NULL,
  kerneltype = NULL,
  initsigma = NULL,
  breedsigma = NULL,
  gravsigma = NULL,
  ovisigma = NULL,
  simdims = NULL,
  lifestage = NULL,
  kernelshape = NULL,
  call = NULL
)
}
\arguments{
\item{data}{tibble of pairwise kin classes & distances. Ideally contains fields id1 & id2 (chr) an distance (dbl) optionally includes coords (x1, y1, x2, y2), lifestage (ls1 & ls2), kinship (chr) and sims (dbl)}

\item{kinship}{character. Code for kinship category of simulation. one of PO, FS, HS, AV, GG, HAV, GGG, 1C, 1C1, 2C, GAV, HGAV, H1C or H2C}

\item{kerneltype}{character. Statistical model for simulated dispersal kernel. Currently either "Gaussian", "Laplace" or "vgamma" (variance-gamma).}

\item{initsigma}{numeric. Axial sigma of prebreeding ('juvenile') dispersal kernel (axial standard deviation).}

\item{breedsigma}{numeric. Axial sigma of breeding dispersal kernel (axial standard deviation).}

\item{gravsigma}{numeric. Axial sigma of post-breeding ('gravid') dispersal kernel (axial standard deviation).}

\item{ovisigma}{numeric. Axial sigma of oviposition dispersal kernel (axial standard deviation).}

\item{simdims}{numeric. Length of side of simulated area square.}

\item{lifestage}{character. Simulated lifestage of sampling. Either "immature" (sampled at hatching) or "ovipositional"
(sampled as an adult during oviposition - essentially one lifespan later than 'immature')}

\item{kernelshape}{numeric. Value of shape parameter for simulated kernel if kernel requires one (e.g. vgamma kernel).}

\item{call}{call object. Use to pass the system call that led to the generation of this class. (via sys.call)}
}
\value{
Returns a \code{KinPairSimulation} Class object with simtype set to 'composite' and relevant fields included.
}
\description{
Constructor for KinPairSimulation Class (composite)
}
\examples{
kindata <- tibble::tibble(
  id1 = c("a", "b", "c"), id2 = c("x", "y", "z"),
  distance = c(50, 45, 65), kinship = c("1C", "1C", "1C")
)
KinPairSimulation_composite(kindata,
  kinship = "1C", kerneltype = "Gaussian",
  initsigma = 15, breedsigma = 25, gravsigma = 20, ovisigma = 10, lifestage = "immature"
)
}
