% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axial_helper_functions.R
\name{axials_decompose}
\alias{axials_decompose}
\title{Decompose an axial distribution into simple components}
\usage{
axials_decompose(ax, n_composites = 2)
}
\arguments{
\item{ax}{numeric. The axial value to be decomposed.}

\item{n_composites}{numeric. The number of separate 'draws' (dispersal events)
from the kernel required to produce the final positions of the measured individuals.
For example, the displacement of a child from parent at the same life stage would involve 1 draw and thus be composite = 1.
Two full siblings would be two draws (composite = 2) from the FS kernel. Non-symmetric relationships (e.g. AV, 1C)
should not be decomposed using this method, nor should any assumptions be made about different kernels
(e.g. the 1C relationship would appropriately be given the value 2, but not 4)}
}
\value{
Returns the (numeric) axial distribution value of the underlying dispersal kernel from which the composite kernel was (or could be) created.
}
\description{
Decomposes an axial distribution into simple components. Note that this should only be used in the simplest situations.
It assumes all composite dispersal events are of identical magnitude and have happened equivalently to both branches of a 'symmetric'
pedigree leading to the final kin dyad. (it can be used to derive e.g.full-sibling dispersal parameters from the distribution of
full-siblings, or equivalent for first cousins, but \strong{not} to divide the 'avuncular' kernel into its
component parts (uncle/aunt & niece/nephew have different dispersal paths from their common ancestor)).
}
\examples{
fs_vect <- c(10, 11, 12)
fs_axial_raw <- axials(fs_vect, composite = 1) # composite hasn't corrected for two dispersal events
# inherent to this kin category!
fs_axial_final <- axials_decompose(fs_axial_raw, n_composites = 2)
}
\seealso{
Other axial_helpers: 
\code{\link{axials_add}()},
\code{\link{axials_subtract}()},
\code{\link{axials}()},
\code{\link{axpermute_subtract}()},
\code{\link{axpermute}()}
}
\concept{axial_helpers}
