% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-tol.R
\name{scale_tol_diverging}
\alias{scale_tol_diverging}
\alias{scale_colour_sunset}
\alias{scale_color_sunset}
\alias{scale_fill_sunset}
\alias{scale_colour_BuRd}
\alias{scale_color_BuRd}
\alias{scale_fill_BuRd}
\alias{scale_colour_PRGn}
\alias{scale_color_PRGn}
\alias{scale_fill_PRGn}
\title{Paul Tol's Diverging Colour Schemes for \pkg{ggplot2}}
\usage{
scale_colour_sunset(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_color_sunset(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_fill_sunset(..., reverse = FALSE, midpoint = 0,
  aesthetics = "fill")

scale_colour_BuRd(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_color_BuRd(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_fill_BuRd(..., reverse = FALSE, midpoint = 0,
  aesthetics = "fill")

scale_colour_PRGn(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_color_PRGn(..., reverse = FALSE, midpoint = 0,
  aesthetics = "colour")

scale_fill_PRGn(..., reverse = FALSE, midpoint = 0,
  aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{continuous_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{midpoint}{A length-one \code{\link{numeric}} vector giving the midpoint
(in data value) of the diverging scale. Defaults to \code{0}.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \code{\link[ggplot2:continuous_scale]{continuous}} scale.
}
\description{
Provides diverging colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
If more colours than defined are needed from a given scheme, the colour
 coordinates are linearly interpolated to provide a continuous version of the
 scheme.
 Note that the default colour for \code{NA} can be overridden by passing
 a value to \code{\link[ggplot2]{continuous_scale}}.

 \tabular{lll}{
  \strong{Palette} \tab \strong{Max. colours} \tab \strong{NA value} \cr
  sunset \tab 11 \tab #FFFFFF \cr
  BuRd \tab 9 \tab #FFEE99 \cr
  PRGn \tab 9 \tab #FFEE99 \cr
 }
}
\examples{
library(ggplot2)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_sunset(midpoint = 12000)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_BuRd(midpoint = 9000)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_color_PRGn(midpoint = 6000)
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
 SRON/EPS/TN/09-002, issue 3.1.
 URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Paul Tol's colour schemes: \code{\link{scale_tol_discrete}},
  \code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
