% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary.R
\name{dictionary}
\alias{dictionary}
\alias{dictionary.character}
\alias{dictionary.connection}
\alias{as_dictionary}
\alias{as_dictionary.kgrams_dictionary}
\alias{as_dictionary.character}
\alias{as.character.kgrams_dictionary}
\title{Word dictionaries}
\usage{
dictionary(text, ...)

\method{dictionary}{character}(
  text,
  .preprocess = identity,
  size = NULL,
  cov = NULL,
  thresh = NULL,
  ...
)

\method{dictionary}{connection}(
  text,
  .preprocess = identity,
  size = NULL,
  cov = NULL,
  thresh = NULL,
  batch_size = NULL,
  ...
)

as_dictionary(object)

\method{as_dictionary}{kgrams_dictionary}(object)

\method{as_dictionary}{character}(object)

\method{as.character}{kgrams_dictionary}(x, ...)
}
\arguments{
\item{text}{a character vector, a connection or missing/\code{NULL}.
Source of text from which k-gram frequencies are to be extracted.}

\item{...}{further arguments passed to or from other methods.}

\item{.preprocess}{a function taking a character vector as input and returning
a character vector as output. Optional preprocessing transformation
applied to text before creating the dictionary.}

\item{size}{either \code{NULL} or a positive integer. Predefined size of the
required dictionary (the top \code{size} most frequent words are retained).}

\item{cov}{either \code{NULL} or a number between \code{0} and \code{1}.
Predefined text coverage fraction of the dictionary
(the most frequent words providing the required coverage are retained).}

\item{thresh}{either \code{NULL} or a positive integer.
Predefined text coverage fraction of the dictionary
(the most frequent words providing the required coverage are retained).}

\item{batch_size}{a length one positive integer or \code{NULL}.
Size of text batches when reading text from a \code{file} or a generic
\code{connection}. If \code{NULL}, all input text is processed in a single
batch.}

\item{object}{an object to be coerced to dictionary.}

\item{x}{a \code{dictionary}.}
}
\value{
A \code{dictionary} for \code{dictionary()} and
\code{as_dictionary()}, a character vector for the \code{as.character()}
method.
}
\description{
Construct or coerce to and from a dictionary.
}
\details{
These generic functions are used to build dictionaries from a text
source, or to coerce other formats to \code{dictionary}, and from a
\code{dictionary} to a character vector. By now, the only
non-trivial type coercible to \code{dictionary} is \code{character},
in which case each entry of the input vector is considered as a single word.
Coercion from \code{dictionary} to \code{character} returns the list of
words included in the dictionary as a regular character vector.

Dictionaries can be \emph{built} from text coming either directly from a
character vector, or from a connection. The second option is useful if one
wants to avoid loading the full text corpus in physical memory,
allowing to process text from different sources such as files, compressed
files or URLs.

A single preprocessing transformation can be applied before processing the
text for unique words. After preprocessing,
\emph{anything delimited by one or more white space characters}
in the transformed text input \emph{is counted as a word} and may be added
to the dictionary modulo additional constraints.

The possible constraints for including a word in the dictionary can be of
three types: (i) fixed size of dictionary, implemented by the \code{size}
argument; (ii) fixed text covering fraction, as specified by the \code{cov}
argument; or (iii) minimum word count threshold, \code{thresh} argument.
\emph{Only one of these constraints can be applied at a time},
so that specifying more than one of \code{size}, \code{cov} or \code{thresh}
raises an error.
}
\examples{
# Building a dictionary from Shakespeare's "Much Ado About Nothing"

dict <- dictionary(much_ado)
length(dict)
query(dict, "leonato") # TRUE
query(dict, c("thy", "thou")) # c(TRUE, TRUE)
query(dict, "smartphones") # FALSE

# Getting list of words as regular character vector
words <- as.character(dict)
head(words)

# Building a dictionary from a list of words
dict <- as_dictionary(c("i", "the", "a"))

}
\author{
Valerio Gherardi
}
