% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{maxLR}
\alias{maxLR}
\title{implements the maximum likelihood ratio test}
\usage{
maxLR(X, Y)
}
\arguments{
\item{X}{covariate matrix}

\item{Y}{response vector}
}
\value{
\eqn{p}-value of the test
}
\description{
The maximum likelihood ratio test is a classical goodness-of-fit
test for linear models. Mathematically speaking, the average
residual sum of squares for an ordinary least squares (OLS) is
approximated as a chi-square distribution to generate a \eqn{p}-value.
}
\details{
The test is valid when the number of samples is larger than the number
of covariates.
}
\examples{
n <- 50
p <- 20
X <- matrix(rnorm(n*p), nrow = n, ncol = p)
Y <- rnorm(n)
stat.likelihood <- maxLR(X, Y)

}
\seealso{
Other LR test: \code{\link{anovaLR}}
}
\concept{LR test}
