% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{CSVLogger}
\alias{CSVLogger}
\title{Callback that streams epoch results to a csv file.}
\usage{
CSVLogger(filename, separator = ",", append = FALSE)
}
\arguments{
\item{filename}{filename of the csv file, e.g. 'run/log.csv'.}

\item{separator}{string used to separate elements in the csv file.}

\item{append}{True: append if file exists (useful for continuing
training). False: overwrite existing file,}
}
\description{
Supports all values that can be represented as a string, including 1D
iterables such as np.ndarray.
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  callbacks <- list(CSVLogger(tempfile()),
                    EarlyStopping(),
                    ReduceLROnPlateau(),
                    TensorBoard(tempfile()))

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, callbacks = callbacks, validation_split = 0.2)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other callbacks: \code{\link{EarlyStopping}},
  \code{\link{ModelCheckpoint}},
  \code{\link{ReduceLROnPlateau}},
  \code{\link{TensorBoard}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
