% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.pooling.R
\name{AveragePooling}
\alias{AveragePooling}
\alias{AveragePooling1D}
\alias{AveragePooling2D}
\alias{AveragePooling3D}
\title{Average pooling operation}
\usage{
AveragePooling1D(pool_size = 2, strides = NULL, padding = "valid",
  input_shape = NULL)

AveragePooling2D(pool_size = c(2, 2), strides = NULL, padding = "valid",
  data_format = NULL, input_shape = NULL)

AveragePooling3D(pool_size = c(2, 2, 2), strides = NULL,
  padding = "valid", data_format = NULL, input_shape = NULL)
}
\arguments{
\item{pool_size}{Integer or pair of integers; size(s) of
the max pooling windows.}

\item{strides}{Integer, pair of integers, or None.
Factor(s) by which to downscale. E.g. 2 will
halve the input. If NULL, it will
default to pool_size.}

\item{padding}{One of "valid" or "same" (case-insensitive).}

\item{input_shape}{nD tensor with shape: \code{(batch_size, ..., input_dim)}.
The most common situation would be a 2D
input with shape \code{(batch_size, input_dim)}.}

\item{data_format}{A string, one of channels_last (default) or
channels_first}
}
\description{
Average pooling operation
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
