% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-utils.R
\name{text_dataset_from_directory}
\alias{text_dataset_from_directory}
\title{Generates a \code{tf.data.Dataset} from text files in a directory.}
\usage{
text_dataset_from_directory(
  directory,
  labels = "inferred",
  label_mode = "int",
  class_names = NULL,
  batch_size = 32L,
  max_length = NULL,
  shuffle = TRUE,
  seed = NULL,
  validation_split = NULL,
  subset = NULL,
  follow_links = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{directory}{Directory where the data is located.
If \code{labels} is \code{"inferred"}, it should contain
subdirectories, each containing text files for a class.
Otherwise, the directory structure is ignored.}

\item{labels}{Either \code{"inferred"}
(labels are generated from the directory structure),
\code{NULL} (no labels),
or a list/tuple of integer labels of the same size as the number of
text files found in the directory. Labels should be sorted according
to the alphanumeric order of the text file paths
(obtained via \code{os.walk(directory)} in Python).}

\item{label_mode}{String describing the encoding of \code{labels}. Options are:
\itemize{
\item \code{"int"}: means that the labels are encoded as integers
(e.g. for \code{sparse_categorical_crossentropy} loss).
\item \code{"categorical"} means that the labels are
encoded as a categorical vector
(e.g. for \code{categorical_crossentropy} loss).
\item \code{"binary"} means that the labels (there can be only 2)
are encoded as \code{float32} scalars with values 0 or 1
(e.g. for \code{binary_crossentropy}).
\item \code{NULL} (no labels).
}}

\item{class_names}{Only valid if \code{"labels"} is \code{"inferred"}.
This is the explicit list of class names
(must match names of subdirectories). Used to control the order
of the classes (otherwise alphanumerical order is used).}

\item{batch_size}{Size of the batches of data. Defaults to 32.
If \code{NULL}, the data will not be batched
(the dataset will yield individual samples).}

\item{max_length}{Maximum size of a text string. Texts longer than this will
be truncated to \code{max_length}.}

\item{shuffle}{Whether to shuffle the data. Defaults to \code{TRUE}.
If set to \code{FALSE}, sorts the data in alphanumeric order.}

\item{seed}{Optional random seed for shuffling and transformations.}

\item{validation_split}{Optional float between 0 and 1,
fraction of data to reserve for validation.}

\item{subset}{Subset of the data to return.
One of \code{"training"}, \code{"validation"} or \code{"both"}.
Only used if \code{validation_split} is set.
When \code{subset="both"}, the utility returns a tuple of two datasets
(the training and validation datasets respectively).}

\item{follow_links}{Whether to visits subdirectories pointed to by symlinks.
Defaults to \code{FALSE}.}

\item{verbose}{Whether to display number information on classes and
number of files found. Defaults to \code{TRUE}.}
}
\value{
A \code{tf.data.Dataset} object.
\itemize{
\item If \code{label_mode} is \code{NULL}, it yields \code{string} tensors of shape
\verb{(batch_size,)}, containing the contents of a batch of text files.
\item Otherwise, it yields a tuple \verb{(texts, labels)}, where \code{texts}
has shape \verb{(batch_size,)} and \code{labels} follows the format described
below.
}

Rules regarding labels format:
\itemize{
\item if \code{label_mode} is \code{int}, the labels are an \code{int32} tensor of shape
\verb{(batch_size,)}.
\item if \code{label_mode} is \code{binary}, the labels are a \code{float32} tensor of
1s and 0s of shape \verb{(batch_size, 1)}.
\item if \code{label_mode} is \code{categorical}, the labels are a \code{float32} tensor
of shape \verb{(batch_size, num_classes)}, representing a one-hot
encoding of the class index.
}
}
\description{
If your directory structure is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{main_directory/
...class_a/
......a_text_1.txt
......a_text_2.txt
...class_b/
......b_text_1.txt
......b_text_2.txt
}\if{html}{\out{</div>}}

Then calling \code{text_dataset_from_directory(main_directory, labels='inferred')} will return a \code{tf.data.Dataset} that yields batches of
texts from the subdirectories \code{class_a} and \code{class_b}, together with labels
0 and 1 (0 corresponding to \code{class_a} and 1 corresponding to \code{class_b}).

Only \code{.txt} files are supported at this time.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/text#textdatasetfromdirectory-function}
}

Other dataset utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr

Other preprocessing: \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
}
\concept{dataset utils}
\concept{preprocessing}
\concept{text dataset utils}
\concept{utils}
