% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_discretization}
\alias{layer_discretization}
\title{A preprocessing layer which buckets continuous features by ranges.}
\usage{
layer_discretization(
  object,
  bin_boundaries = NULL,
  num_bins = NULL,
  epsilon = 0.01,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{bin_boundaries}{A list of bin boundaries. The leftmost and rightmost bins
will always extend to \code{-Inf} and \code{Inf}, so \code{bin_boundaries = c(0., 1., 2.)}
generates bins \verb{(-Inf, 0.)}, \verb{[0., 1.)}, \verb{[1., 2.)}, and \verb{[2., +Inf)}. If
this option is set, \code{adapt} should not be called.}

\item{num_bins}{The integer number of bins to compute. If this option is set,
\code{adapt} should be called to learn the bin boundaries.}

\item{epsilon}{Error tolerance, typically a small fraction close to zero (e.g.
0.01). Higher values of epsilon increase the quantile approximation, and
hence result in more unequal buckets, but could improve performance
and resource consumption.}

\item{...}{standard layer arguments.}
}
\description{
A preprocessing layer which buckets continuous features by ranges.
}
\details{
This layer will place each element of its input data into one of several
contiguous ranges and output an integer index indicating which range each
element was placed in.

Input shape:
Any \code{tf.Tensor} or \code{tf.RaggedTensor} of dimension 2 or higher.

Output shape:
Same as input shape.
}
\seealso{
\itemize{
\item \code{\link[=adapt]{adapt()}}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Discretization}
\item \url{https://keras.io/api/layers/preprocessing_layers/numerical/discretization}
}

Other numerical features preprocessing layers: 
\code{\link{layer_normalization}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_brightness}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{numerical features preprocessing layers}
\concept{preprocessing layers}
