% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-attention.R
\name{layer_additive_attention}
\alias{layer_additive_attention}
\title{Additive attention layer, a.k.a. Bahdanau-style attention}
\usage{
layer_additive_attention(
  object,
  use_scale = TRUE,
  ...,
  causal = FALSE,
  dropout = 0
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{use_scale}{If \code{TRUE}, will create a variable to scale the attention scores.}

\item{...}{standard layer arguments.}

\item{causal}{Boolean. Set to \code{TRUE} for decoder self-attention. Adds a mask such
that position \code{i} cannot attend to positions \code{j > i}. This prevents the
flow of information from the future towards the past.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
attention scores.}
}
\description{
Additive attention layer, a.k.a. Bahdanau-style attention
}
\details{
Inputs are \code{query} tensor of shape \verb{[batch_size, Tq, dim]}, \code{value} tensor of
shape \verb{[batch_size, Tv, dim]} and \code{key} tensor of shape
\verb{[batch_size, Tv, dim]}. The calculation follows the steps:
\enumerate{
\item Reshape \code{query} and \code{key} into shapes \verb{[batch_size, Tq, 1, dim]}
and \verb{[batch_size, 1, Tv, dim]} respectively.
\item Calculate scores with shape \verb{[batch_size, Tq, Tv]} as a non-linear
sum: \code{scores = tf.reduce_sum(tf.tanh(query + key), axis=-1)}
\item Use scores to calculate a distribution with shape
\verb{[batch_size, Tq, Tv]}: \code{distribution = tf$nn$softmax(scores)}.
\item Use \code{distribution} to create a linear combination of \code{value} with
shape \verb{[batch_size, Tq, dim]}:
\verb{return tf$matmul(distribution, value)}.
}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/AdditiveAttention}
\item \url{https://keras.io/api/layers/attention_layers/additive_attention/}
}
}
