% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_category_encoding}
\alias{layer_category_encoding}
\title{A preprocessing layer which encodes integer features.}
\usage{
layer_category_encoding(
  object,
  num_tokens = NULL,
  output_mode = "multi_hot",
  sparse = FALSE,
  ...
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{num_tokens}{The total number of tokens the layer should support. All
inputs to the layer must integers in the range \verb{0 <= value < num_tokens},
or an error will be thrown.}

\item{output_mode}{Specification for the output of the layer. Defaults to
\code{"multi_hot"}. Values can be \code{"one_hot"}, \code{"multi_hot"} or \code{"count"},
configuring the layer as follows:
\itemize{
\item \code{"one_hot"}: Encodes each individual element in the input into an array
of \code{num_tokens} size, containing a 1 at the element index. If the last
dimension is size 1, will encode on that dimension. If the last dimension
is not size 1, will append a new dimension for the encoded output.
\item \code{"multi_hot"}: Encodes each sample in the input into a single array of
\code{num_tokens} size, containing a 1 for each vocabulary term present in the
sample. Treats the last dimension as the sample dimension, if input shape
is \verb{(..., sample_length)}, output shape will be \verb{(..., num_tokens)}.
\item \code{"count"}: Like \code{"multi_hot"}, but the int array contains a count of the
number of times the token at that index appeared in the sample.
}

For all output modes, currently only output up to rank 2 is supported.}

\item{sparse}{Boolean. If \code{TRUE}, returns a \code{SparseTensor} instead of a dense
\code{Tensor}. Defaults to \code{FALSE}.}

\item{...}{standard layer arguments.}
}
\description{
This layer provides options for condensing data into a categorical encoding
when the total number of tokens are known in advance. It accepts integer
values as inputs, and it outputs a dense or sparse representation of those
inputs. For integer inputs where the total number of tokens is not known, use
\code{\link[=layer_integer_lookup]{layer_integer_lookup()}} instead.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/CategoryEncoding}
\item \url{https://keras.io/api/layers/preprocessing_layers/categorical/category_encoding/}
}

Other categorical features preprocessing layers: 
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_string_lookup}()}

Other preprocessing layers: 
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{categorical features preprocessing layers}
\concept{preprocessing layers}
