% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new-py-types.R
\name{mark_active}
\alias{mark_active}
\alias{new_metric_class}
\alias{new_loss_class}
\alias{new_callback_class}
\alias{new_model_class}
\alias{new_layer_class}
\title{Define new keras types}
\usage{
mark_active(x)

new_metric_class(classname, ..., initialize, update_state, result)

new_loss_class(classname, ..., call = NULL)

new_callback_class(
  classname,
  ...,
  on_epoch_begin = NULL,
  on_epoch_end = NULL,
  on_train_begin = NULL,
  on_train_end = NULL,
  on_batch_begin = NULL,
  on_batch_end = NULL,
  on_predict_batch_begin = NULL,
  on_predict_batch_end = NULL,
  on_predict_begin = NULL,
  on_predict_end = NULL,
  on_test_batch_begin = NULL,
  on_test_batch_end = NULL,
  on_test_begin = NULL,
  on_test_end = NULL,
  on_train_batch_begin = NULL,
  on_train_batch_end = NULL
)

new_model_class(
  classname,
  ...,
  initialize = NULL,
  call = NULL,
  train_step = NULL,
  predict_step = NULL,
  test_step = NULL,
  compute_loss = NULL,
  compute_metrics = NULL
)

new_layer_class(
  classname,
  ...,
  initialize = NULL,
  build = NULL,
  call = NULL,
  get_config = NULL
)
}
\arguments{
\item{x}{A function that should be converted to an active property of the class type.}

\item{classname}{The classname as a string. Convention is for the classname
to be a CamelCase version of the constructor.}

\item{...}{Additional fields and methods for the new type.}

\item{initialize, build, call, get_config, on_epoch_begin, on_epoch_end, on_train_begin, on_train_end, on_batch_begin, on_batch_end, on_predict_batch_begin, on_predict_batch_end, on_predict_begin, on_predict_end, on_test_batch_begin, on_test_batch_end, on_test_begin, on_test_end, on_train_batch_begin, on_train_batch_end, update_state, result, train_step, predict_step, test_step, compute_loss, compute_metrics}{Optional methods that can be overridden.}
}
\value{
A new class generator object that inherits from the appropriate Keras
base class.
}
\description{
These functions can be used to make custom objects that fit in the family of
existing keras types. For example, \code{new_layer_class()} will return a class
constructor, an object that behaves like other layer functions such as
\code{layer_dense()}. \code{new_callback_class()} will return an object that behaves
similarly to other callback functions, like
\code{callback_reduce_lr_on_plateau()}, and so on. All arguments with a default
\code{NULL} value are optional methods that can be provided.
}
\details{
\code{mark_active()} is a decorator that can be used to indicate functions that
should become active properties of the class instances.
}
