% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_nasnet}
\alias{application_nasnet}
\alias{application_nasnetlarge}
\alias{application_nasnetmobile}
\alias{nasnet_preprocess_input}
\title{Instantiates a NASNet model.}
\usage{
application_nasnet(input_shape = NULL, penultimate_filters = 4032L,
  num_blocks = 6L, stem_block_filters = 96L, skip_reduction = TRUE,
  filter_multiplier = 2L, include_top = TRUE, weights = NULL,
  input_tensor = NULL, pooling = NULL, classes = 1000,
  default_size = NULL)

application_nasnetlarge(input_shape = NULL, include_top = TRUE,
  weights = NULL, input_tensor = NULL, pooling = NULL, classes = 1000)

application_nasnetmobile(input_shape = NULL, include_top = TRUE,
  weights = NULL, input_tensor = NULL, pooling = NULL, classes = 1000)

nasnet_preprocess_input(x)
}
\arguments{
\item{input_shape}{Optional shape list, the input shape is by default \code{(331, 331, 3)}
for NASNetLarge and \code{(224, 224, 3)} for NASNetMobile It should have exactly 3
inputs channels, and width and height should be no smaller than 32. E.g.
\code{(224, 224, 3)} would be one valid value.}

\item{penultimate_filters}{Number of filters in the penultimate layer.
NASNet models use the notation \code{NASNet (N @ P)}, where:
- N is the number of blocks
- P is the number of penultimate filters}

\item{num_blocks}{Number of repeated blocks of the NASNet model. NASNet
models use the notation \code{NASNet (N @ P)}, where:
- N is the number of blocks
- P is the number of penultimate filters}

\item{stem_block_filters}{Number of filters in the initial stem block}

\item{skip_reduction}{Whether to skip the reduction step at the tail end
of the network. Set to \code{FALSE} for CIFAR models.}

\item{filter_multiplier}{Controls the width of the network.
\itemize{
\item If \code{filter_multiplier} < 1.0, proportionally decreases the number of
filters in each layer.
\item If \code{filter_multiplier} > 1.0, proportionally increases the number of
filters in each layer. - If \code{filter_multiplier} = 1, default number of
filters from the paper are used at each layer.
}}

\item{include_top}{Whether to include the fully-connected layer at the top
of the network.}

\item{weights}{\code{NULL} (random initialization) or \code{imagenet} (ImageNet weights)}

\item{input_tensor}{Optional Keras tensor (i.e. output of \code{layer_input()})
to use as image input for the model.}

\item{pooling}{Optional pooling mode for feature extraction when
\code{include_top} is \code{FALSE}.
- \code{NULL} means that the output of the model will be the 4D tensor output
of the last convolutional layer.
- \code{avg} means that global average pooling will be applied to the output
of the last convolutional layer, and thus the output of the model will
be a 2D tensor.
- \code{max} means that global max pooling will be applied.}

\item{classes}{Optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified.}

\item{default_size}{Specifies the default image size of the model}

\item{x}{a 4D array consists of RGB values within \code{[0, 255]}.}
}
\description{
Note that only TensorFlow is supported for now,
therefore it only works with the data format
\code{image_data_format='channels_last'} in your Keras config
at \code{~/.keras/keras.json}.
}
