% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{simulate.kdecopula}
\alias{simulate.kdecopula}
\title{Simulate data from a \code{kdecop()} fit.}
\usage{
\method{simulate}{kdecopula}(object, nsim = 1, seed = NULL, quasi = FALSE,
  ...)
}
\arguments{
\item{object}{an object of class \code{kdecopula}.}

\item{nsim}{integer; number of observations.}

\item{seed}{integer; \code{set.seed(seed)} will be called prior to \code{rkdecop()}.}

\item{quasi}{logical; the default (\code{FALSE}) returns pseudo-random
numbers, use \code{TRUE} for quasi-random numbers (generalized Halton, see}

\item{...}{unused.}
}
\value{
Simulated data from the fitted \code{kdecopula} model.
}
\description{
See \code{rkdecop()}.
}
\examples{
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))
fit <- kdecop(udat[, 5:6])
plot(simulate(fit, 500))

}
